/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.ParameterizedTypeTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1319", name="Declarations should use Java collection interfaces such as \"List\" rather than specific implementation classes such as \"LinkedList\"", tags={"bad-practice"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class CollectionImplementationReferencedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final String DEQUE = "Deque";
    private static final String LIST = "List";
    private static final String MAP = "Map";
    private static final String CONCURRENT_MAP = "ConcurrentMap";
    private static final String QUEUE = "Queue";
    private static final String SET = "Set";
    private static final String SORTED_MAP = "SortedMap";
    private static final String SORTED_SET = "SortedSet";
    private static final Map<String, String> MAPPING = ImmutableMap.builder().put((Object)"ArrayDeque", (Object)"Deque").put((Object)"ConcurrentLinkedDeque", (Object)"Deque").put((Object)"AbstractList", (Object)"List").put((Object)"AbstractSequentialList", (Object)"List").put((Object)"ArrayList", (Object)"List").put((Object)"CopyOnWriteArrayList", (Object)"List").put((Object)"LinkedList", (Object)"List").put((Object)"AbstractMap", (Object)"Map").put((Object)"EnumMap", (Object)"Map").put((Object)"HashMap", (Object)"Map").put((Object)"Hashtable", (Object)"Map").put((Object)"IdentityHashMap", (Object)"Map").put((Object)"LinkedHashMap", (Object)"Map").put((Object)"WeakHashMap", (Object)"Map").put((Object)"ConcurrentHashMap", (Object)"ConcurrentMap").put((Object)"ConcurrentSkipListMap", (Object)"ConcurrentMap").put((Object)"AbstractQueue", (Object)"Queue").put((Object)"ConcurrentLinkedQueue", (Object)"Queue").put((Object)"SynchronousQueue", (Object)"Queue").put((Object)"AbstractSet", (Object)"Set").put((Object)"CopyOnWriteArraySet", (Object)"Set").put((Object)"EnumSet", (Object)"Set").put((Object)"HashSet", (Object)"Set").put((Object)"LinkedHashSet", (Object)"Set").put((Object)"TreeMap", (Object)"SortedMap").put((Object)"TreeSet", (Object)"SortedSet").build();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        super.visitVariable(tree);
        String collectionImplementation = CollectionImplementationReferencedCheck.getTypeIdentifierOrNull((Tree)tree.type());
        String collectionInterface = MAPPING.get(collectionImplementation);
        if (collectionInterface != null) {
            this.context.addIssue((Tree)tree.type(), (JavaCheck)this, "The type of the \"" + tree.simpleName() + "\" object " + CollectionImplementationReferencedCheck.messageRemainder(collectionImplementation, collectionInterface));
        }
    }

    public void visitMethod(MethodTree tree) {
        super.visitMethod(tree);
        String collectionImplementation = CollectionImplementationReferencedCheck.getTypeIdentifierOrNull((Tree)tree.returnType());
        String collectionInterface = MAPPING.get(collectionImplementation);
        if (collectionInterface != null) {
            this.context.addIssue((Tree)tree.returnType(), (JavaCheck)this, "The return type of this method " + CollectionImplementationReferencedCheck.messageRemainder(collectionImplementation, collectionInterface));
        }
    }

    private static String getTypeIdentifierOrNull(Tree tree) {
        if (tree == null) {
            return null;
        }
        Tree actualTree = tree.is(new Tree.Kind[]{Tree.Kind.PARAMETERIZED_TYPE}) ? ((ParameterizedTypeTree)tree).type() : tree;
        return actualTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? ((IdentifierTree)actualTree).name() : null;
    }

    private static String messageRemainder(String collectionImplementation, String collectionInterface) {
        return "should be an interface such as \"" + collectionInterface + "\" rather than the implementation \"" + collectionImplementation + "\".";
    }
}

