/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1699", name="Constructors should only call non-overridable methods", tags={"bug"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class ConstructorCallingOverridableCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CONSTRUCTOR);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            MethodTree methodTree = (MethodTree)tree;
            JavaSymbol.TypeJavaSymbol constructorType = (JavaSymbol.TypeJavaSymbol)this.getSemanticModel().getEnclosingClass(tree);
            if (!constructorType.isFinal()) {
                ConstructorBodyVisitor constructorBodyVisitor = new ConstructorBodyVisitor(constructorType);
                methodTree.block().accept((TreeVisitor)constructorBodyVisitor);
            }
        }
    }

    private class ConstructorBodyVisitor
    extends BaseTreeVisitor {
        private JavaSymbol.TypeJavaSymbol constructorType;

        public ConstructorBodyVisitor(JavaSymbol.TypeJavaSymbol constructorType) {
            this.constructorType = constructorType;
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol symbol;
            IdentifierTree methodIdentifier = null;
            boolean isInvocationOnSelf = false;
            ExpressionTree methodSelect = tree.methodSelect();
            if (methodSelect.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                methodIdentifier = (IdentifierTree)methodSelect;
                isInvocationOnSelf = true;
            } else if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree memberSelect = (MemberSelectExpressionTree)methodSelect;
                methodIdentifier = memberSelect.identifier();
                isInvocationOnSelf = this.isThisOrSuper(memberSelect.expression());
            }
            if (isInvocationOnSelf && this.isOverridableMethod(symbol = methodIdentifier.symbol()) && this.isMethodDefinedOnConstructedType(symbol)) {
                ConstructorCallingOverridableCheck.this.addIssue((Tree)tree, "Remove this call from a constructor to the overridable \"" + methodIdentifier.name() + "\" method.");
            }
            super.visitMethodInvocation(tree);
        }

        private boolean isThisOrSuper(ExpressionTree expression) {
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                String targetName = ((IdentifierTree)expression).name();
                return "this".equals(targetName) || "super".equals(targetName);
            }
            return false;
        }

        private boolean isMethodDefinedOnConstructedType(Symbol symbol) {
            JavaSymbol.TypeJavaSymbol methodEnclosingClass = (JavaSymbol.TypeJavaSymbol)symbol.enclosingClass();
            for (JavaType.ClassJavaType superType : this.constructorType.superTypes()) {
                if (!superType.getSymbol().equals(methodEnclosingClass)) continue;
                return true;
            }
            return this.constructorType.equals(methodEnclosingClass);
        }

        private boolean isOverridableMethod(Symbol symbol) {
            return symbol.isMethodSymbol() && !symbol.isPrivate() && !symbol.isFinal() && !symbol.isStatic();
        }
    }
}

