/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2257", name="Only standard cryptographic algorithms should be used", tags={"cwe", "owasp-top10", "sans-top25", "security"}, priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="1d")
public class CustomCryptographicAlgorithmCheck
extends SubscriptionBaseVisitor {
    private static final String MESSAGE_DIGEST_QUALIFIED_NAME = "java.security.MessageDigest";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic() && this.isJavaSecurityMessageDigestSubClass((ClassTree)tree)) {
            this.addIssue(tree, "Use a standard algorithm instead of creating a custom one.");
        }
    }

    private boolean isJavaSecurityMessageDigestSubClass(ClassTree tree) {
        Symbol.TypeSymbol classSymbol = tree.symbol();
        return classSymbol != null && !classSymbol.type().is(MESSAGE_DIGEST_QUALIFIED_NAME) && classSymbol.type().isSubtypeOf(MESSAGE_DIGEST_QUALIFIED_NAME);
    }
}

