/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2718", name="\"DateUtils.truncate\" from Apache Commons Lang library should not be used", tags={"java8", "performance"}, priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="10min")
public class DateUtilsTruncateCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.truncateMethodMatcher("java.util.Date"), (Object)this.truncateMethodMatcher("java.util.Calendar"), (Object)this.truncateMethodMatcher("java.lang.Object"));
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Use \"Instant.truncatedTo\" instead.");
    }

    private MethodInvocationMatcher truncateMethodMatcher(String firstParameterType) {
        return MethodInvocationMatcher.create().typeDefinition("org.apache.commons.lang.time.DateUtils").name("truncate").addParameter(firstParameterType).addParameter("int");
    }
}

