/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1206", name="\"equals(Object obj)\" and \"hashCode()\" should be overridden in pairs", tags={"bug", "cert", "cwe"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class EqualsOverridenWithHashCodeCheck
extends SubscriptionBaseVisitor {
    private static final String HASHCODE = "hashCode";
    private static final String EQUALS = "equals";

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            MethodTree equalsMethod = null;
            MethodTree hashCodeMethod = null;
            for (Tree memberTree : classTree.members()) {
                if (!memberTree.is(new Tree.Kind[]{Tree.Kind.METHOD})) continue;
                MethodTree methodTree = (MethodTree)memberTree;
                if (this.isEquals(methodTree)) {
                    equalsMethod = methodTree;
                    continue;
                }
                if (!this.isHashCode(methodTree)) continue;
                hashCodeMethod = methodTree;
            }
            if (equalsMethod != null && hashCodeMethod == null) {
                this.addIssue((Tree)equalsMethod, this.getMessage(EQUALS, HASHCODE));
            } else if (hashCodeMethod != null && equalsMethod == null) {
                this.addIssue((Tree)hashCodeMethod, this.getMessage(HASHCODE, EQUALS));
            }
        }
    }

    private boolean isEquals(MethodTree methodTree) {
        return ((MethodTreeImpl)methodTree).isEqualsMethod();
    }

    private boolean isHashCode(MethodTree methodTree) {
        return HASHCODE.equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && this.returnsInt(methodTree);
    }

    private boolean returnsInt(MethodTree tree) {
        TypeTree typeTree = tree.returnType();
        return typeTree != null && typeTree.symbolType().isPrimitive(Type.Primitives.INT);
    }

    private String getMessage(String overridenMethod, String methodToOverride) {
        return "This class overrides \"" + overridenMethod + "()\" and should therefore also override \"" + methodToOverride + "()\".";
    }
}

