/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.sonar.api.utils.SonarException;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.CharsetAwareVisitor;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1451", name="Copyright and license headers should be defined", tags={}, priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="5min")
public class FileHeaderCheck
extends SubscriptionBaseVisitor
implements CharsetAwareVisitor {
    private static final String DEFAULT_HEADER_FORMAT = "";
    @RuleProperty(key="headerFormat", description="Expected copyright and license header (plain text)", type="TEXT", defaultValue="")
    public String headerFormat = "";
    private Charset charset;
    private String[] expectedLines;

    public void setCharset(Charset charset) {
        this.charset = charset;
    }

    public List<Tree.Kind> nodesToVisit() {
        return Collections.emptyList();
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.expectedLines = this.headerFormat.split("(?:\r)?\n|\r");
        this.visitFile(context.getFile());
    }

    public void visitFile(File file) {
        List lines;
        try {
            lines = Files.readLines((File)file, (Charset)this.charset);
        }
        catch (IOException e) {
            throw new SonarException((Throwable)e);
        }
        if (!FileHeaderCheck.matches(this.expectedLines, lines)) {
            this.addIssueOnFile("Add or update the header of this file.");
        }
    }

    private static boolean matches(String[] expectedLines, List<String> lines) {
        boolean result;
        if (expectedLines.length <= lines.size()) {
            result = true;
            Iterator<String> it = lines.iterator();
            for (int i = 0; i < expectedLines.length; ++i) {
                String line = it.next();
                if (line.equals(expectedLines[i])) continue;
                result = false;
                break;
            }
        } else {
            result = false;
        }
        return result;
    }
}

