/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ForLoopCounterChangedCheck", name="Loop invariants should not be calculated inside the loop", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="3min")
public class ForLoopCounterChangedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private final Set<String> loopCounters = Sets.newHashSet();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopCounters.clear();
        this.scan((Tree)context.getTree());
    }

    public void visitForStatement(ForStatementTree tree) {
        HashSet pendingLoopCounters = Sets.newHashSet();
        for (StatementTree statementTree : tree.initializer()) {
            if (!statementTree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            pendingLoopCounters.add(((VariableTree)statementTree).simpleName().name());
        }
        this.scan(tree.initializer());
        this.scan((Tree)tree.condition());
        this.scan(tree.update());
        this.loopCounters.addAll(pendingLoopCounters);
        this.scan((Tree)tree.statement());
        this.loopCounters.removeAll(pendingLoopCounters);
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkIdentifier((IdentifierTree)tree.variable());
        }
        super.visitAssignmentExpression(tree);
    }

    public void visitUnaryExpression(UnaryExpressionTree tree) {
        if ((this.isIncrement(tree) || this.isDecrement(tree)) && tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.checkIdentifier((IdentifierTree)tree.expression());
        }
        super.visitUnaryExpression(tree);
    }

    private boolean isIncrement(UnaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_INCREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_INCREMENT});
    }

    private boolean isDecrement(UnaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.POSTFIX_DECREMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.PREFIX_DECREMENT});
    }

    private void checkIdentifier(IdentifierTree identifierTree) {
        if (this.loopCounters.contains(identifierTree.name())) {
            this.context.addIssue((Tree)identifierTree, (JavaCheck)this, "Refactor the code in order to not assign to this loop counter from within the loop body.");
        }
    }
}

