/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2096", name="\"main\" should not \"throw\" anything", tags={"error-handling"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="EXCEPTION_HANDLING")
@SqaleConstantRemediation(value="15min")
public class MainMethodThrowsExceptionCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTreeImpl methodTree = (MethodTreeImpl)tree;
        if (methodTree.isMainMethod() && !methodTree.throwsClauses().isEmpty()) {
            this.addIssue(tree, "Remove this throws clause.");
        }
    }
}

