/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1141", name="Try-catch blocks should not be nested", tags={"confusing"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="20min")
public class NestedTryCatchCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private int nestingLevel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.nestingLevel = 0;
        this.scan((Tree)context.getTree());
    }

    public void visitTryStatement(TryStatementTree tree) {
        this.scan(tree.resources());
        if (!tree.catches().isEmpty()) {
            ++this.nestingLevel;
            if (this.nestingLevel > 1) {
                this.context.addIssue((Tree)tree.block(), (JavaCheck)this, "Extract this nested try block into a separate method.");
            }
        }
        this.scan((Tree)tree.block());
        if (!tree.catches().isEmpty()) {
            --this.nestingLevel;
        }
        this.scan(tree.catches());
        this.scan((Tree)tree.finallyBlock());
    }
}

