/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2133", name="Objects should not be created only to \"getClass\"", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class ObjectCreatedOnlyToCallGetClassCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.Object")).name("getClass"));
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (this.hasSemantic() && mit.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expressionTree = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
            if (expressionTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                this.reportIssue(expressionTree);
            } else if (expressionTree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.variableUsedOnlyToGetClass((IdentifierTree)expressionTree)) {
                this.reportIssue(this.getInitializer((IdentifierTree)expressionTree));
            }
        }
    }

    @CheckForNull
    private ExpressionTree getInitializer(IdentifierTree tree) {
        VariableTree declaration;
        Symbol symbol = tree.symbol();
        if (symbol.isVariableSymbol() && (declaration = ((Symbol.VariableSymbol)symbol).declaration()) != null) {
            return declaration.initializer();
        }
        return null;
    }

    private boolean variableUsedOnlyToGetClass(IdentifierTree tree) {
        if ("this".equals(tree.name()) || "super".equals(tree.name())) {
            return false;
        }
        Symbol symbol = tree.symbol();
        return symbol.usages().size() == 1 && this.hasBeenInitialized(tree);
    }

    private boolean hasBeenInitialized(IdentifierTree tree) {
        ExpressionTree initializer = this.getInitializer(tree);
        return initializer != null && initializer.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS});
    }

    private void reportIssue(@Nullable ExpressionTree expressionTree) {
        if (expressionTree != null) {
            this.addIssue((Tree)expressionTree, "Remove this object instantiation and use \"" + this.getTypeName(expressionTree) + ".class\" instead.");
        }
    }

    private String getTypeName(ExpressionTree tree) {
        Type type = tree.symbolType();
        String name = this.getTypeName(type);
        if (name.isEmpty()) {
            name = this.getAnonymousClassTypeName(type.symbol());
        }
        return name;
    }

    private String getAnonymousClassTypeName(Symbol.TypeSymbol symbol) {
        String name = "";
        name = symbol.interfaces().isEmpty() ? this.getTypeName(symbol.superClass()) : this.getTypeName((Type)symbol.interfaces().get(0));
        return name;
    }

    private String getTypeName(Type type) {
        return type.symbol().name();
    }
}

