/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.PrimitiveTypeTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ObjectFinalizeOverridenCallsSuperFinalizeCheck", name="super.finalize() should be called at the end of Object.finalize() implementations", tags={"bug", "cert", "cwe"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ObjectFinalizeOverridenCallsSuperFinalizeCheck
extends SubscriptionBaseVisitor {
    private MethodInvocationTree lastStatementTree;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD, (Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            MemberSelectExpressionTree mset;
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree;
            if (methodInvocationTree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && "finalize".equals((mset = (MemberSelectExpressionTree)methodInvocationTree.methodSelect()).identifier().name()) && mset.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "super".equals(((IdentifierTree)mset.expression()).name())) {
                this.lastStatementTree = methodInvocationTree;
            }
        } else if (this.isFinalize((MethodTree)tree)) {
            this.lastStatementTree = null;
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD}) && this.isFinalize((MethodTree)tree)) {
            MethodTree methodTree = (MethodTree)tree;
            if (this.lastStatementTree == null) {
                this.addIssue((Tree)methodTree.simpleName(), "Add a call to super.finalize() at the end of this Object.finalize() implementation.");
            } else if (!this.isLastStatement(methodTree, this.lastStatementTree)) {
                this.addIssue((Tree)this.lastStatementTree, "Move this super.finalize() call to the end of this Object.finalize() implementation.");
            }
        }
    }

    private boolean isLastStatement(MethodTree methodTree, MethodInvocationTree lastStatementTree) {
        BlockTree blockTree = methodTree.block();
        if (blockTree != null) {
            for (StatementTree statementTree : blockTree.body()) {
                if (!statementTree.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT}) || !this.isLastStatement(((TryStatementTree)statementTree).finallyBlock(), lastStatementTree)) continue;
                return true;
            }
        }
        return this.isLastStatement(blockTree, lastStatementTree);
    }

    private boolean isLastStatement(@Nullable BlockTree blockTree, MethodInvocationTree lastStatementTree) {
        if (blockTree != null) {
            StatementTree last = (StatementTree)Iterables.getLast((Iterable)blockTree.body());
            if (last.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                return lastStatementTree.equals(((ExpressionStatementTree)last).expression());
            }
            if (last.is(new Tree.Kind[]{Tree.Kind.TRY_STATEMENT})) {
                return this.isLastStatement(((TryStatementTree)last).finallyBlock(), lastStatementTree);
            }
        }
        return false;
    }

    private boolean isFinalize(MethodTree methodTree) {
        TypeTree returnType;
        if ("finalize".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && (returnType = methodTree.returnType()) != null && returnType.is(new Tree.Kind[]{Tree.Kind.PRIMITIVE_TYPE})) {
            return "void".equals(((PrimitiveTypeTree)returnType).keyword().text());
        }
        return false;
    }
}

