/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2131", name="Primitives should not be boxed just for \"String\" conversion", tags={"performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="5min")
public class PrimitiveTypeBoxingWithToStringCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return this.getToStringMatchers("java.lang.Byte", "java.lang.Character", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Boolean");
    }

    private List<MethodInvocationMatcher> getToStringMatchers(String ... typeFullyQualifiedNames) {
        ArrayList matchers = Lists.newArrayList();
        for (String fullyQualifiedName : typeFullyQualifiedNames) {
            matchers.add(MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf(fullyQualifiedName)).name("toString"));
        }
        return matchers;
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        ExpressionTree abstractTypedTree = ((MemberSelectExpressionTree)mit.methodSelect()).expression();
        if (abstractTypedTree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) || this.isValueOfInvocation(abstractTypedTree)) {
            String typeName = abstractTypedTree.symbolType().toString();
            this.addIssue((Tree)mit, "Use \"" + typeName + ".toString\" instead.");
        }
    }

    private boolean isValueOfInvocation(ExpressionTree abstractTypedTree) {
        if (!abstractTypedTree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            return false;
        }
        Type type = abstractTypedTree.symbolType();
        MethodInvocationMatcher valueOfMatcher = MethodInvocationMatcher.create().typeDefinition(type.fullyQualifiedName()).name("valueOf").addParameter(((JavaType)type).primitiveType().fullyQualifiedName());
        return valueOfMatcher.matches((MethodInvocationTree)abstractTypedTree);
    }
}

