/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1656", name="Variables should not be self-assigned", tags={"bug", "cert"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="3min")
public class SelfAssignementCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && SyntacticEquivalence.areEquivalent((Tree)tree.expression(), (Tree)tree.variable())) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Remove or correct this useless self-assignment");
        }
        super.visitAssignmentExpression(tree);
    }
}

