/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.LiteralUtils;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.SymbolMetadata;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2057", name="\"Serializable\" classes should have a version id", tags={"pitfall", "serialization"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="DATA_CHANGEABILITY")
@SqaleConstantRemediation(value="5min")
public class SerialVersionUidCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        if (this.hasSemantic()) {
            this.visitClassTree((ClassTree)tree);
        }
    }

    private void visitClassTree(ClassTree classTree) {
        Symbol.TypeSymbol symbol = classTree.symbol();
        if (!this.isAnonymous(classTree) && this.isSerializable(symbol.type())) {
            Symbol.VariableSymbol serialVersionUidSymbol = this.findSerialVersionUid(symbol);
            if (serialVersionUidSymbol == null) {
                if (!this.isExclusion(symbol)) {
                    this.addIssue((Tree)classTree, "Add a \"static final long serialVersionUID\" field to this class.");
                }
            } else {
                this.checkModifiers(serialVersionUidSymbol);
            }
        }
    }

    private boolean isAnonymous(ClassTree classTree) {
        return classTree.simpleName() == null;
    }

    private void checkModifiers(Symbol.VariableSymbol serialVersionUidSymbol) {
        VariableTree tree;
        ArrayList missingModifiers = Lists.newArrayList();
        if (!serialVersionUidSymbol.isStatic()) {
            missingModifiers.add("static");
        }
        if (!serialVersionUidSymbol.isFinal()) {
            missingModifiers.add("final");
        }
        if (!serialVersionUidSymbol.type().is("long")) {
            missingModifiers.add("long");
        }
        if ((tree = serialVersionUidSymbol.declaration()) != null && !missingModifiers.isEmpty()) {
            this.addIssue((Tree)tree, "Make this \"serialVersionUID\" field \"" + Joiner.on((char)' ').join((Iterable)missingModifiers) + "\".");
        }
    }

    private Symbol.VariableSymbol findSerialVersionUid(Symbol.TypeSymbol symbol) {
        for (Symbol member : symbol.lookupSymbols("serialVersionUID")) {
            if (!member.isVariableSymbol()) continue;
            return (Symbol.VariableSymbol)member;
        }
        return null;
    }

    private boolean isSerializable(Type type) {
        return type.isSubtypeOf("java.io.Serializable");
    }

    private boolean isExclusion(Symbol.TypeSymbol symbol) {
        return symbol.isAbstract() || symbol.type().isSubtypeOf("java.lang.Throwable") || this.isGuiClass((JavaSymbol.TypeJavaSymbol)symbol) || this.hasSuppressWarningAnnotation((JavaSymbol.TypeJavaSymbol)symbol);
    }

    private boolean isGuiClass(JavaSymbol.TypeJavaSymbol symbol) {
        for (JavaType.ClassJavaType superType : symbol.superTypes()) {
            JavaSymbol.TypeJavaSymbol superTypeSymbol = superType.getSymbol();
            if (!this.hasGuiPackage(superTypeSymbol)) continue;
            return true;
        }
        return this.hasGuiPackage(symbol) || !symbol.equals(symbol.outermostClass()) && this.isGuiClass(symbol.outermostClass());
    }

    private boolean hasGuiPackage(JavaSymbol.TypeJavaSymbol superTypeSymbol) {
        String fullyQualifiedName = superTypeSymbol.getFullyQualifiedName();
        return fullyQualifiedName.startsWith("javax.swing.") || fullyQualifiedName.startsWith("java.awt.");
    }

    private boolean hasSuppressWarningAnnotation(JavaSymbol.TypeJavaSymbol symbol) {
        List annotations = symbol.metadata().valuesForAnnotation("java.lang.SuppressWarnings");
        if (annotations != null) {
            for (SymbolMetadata.AnnotationValue annotationValue : annotations) {
                if (!"serial".equals(this.stringLiteralValue(annotationValue.value()))) continue;
                return true;
            }
        }
        return false;
    }

    private String stringLiteralValue(Object object) {
        if (object instanceof LiteralTree) {
            LiteralTree literal = (LiteralTree)object;
            return LiteralUtils.trimQuotes((String)literal.value());
        }
        return null;
    }
}

