/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Deque;
import java.util.LinkedList;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.model.SyntacticEquivalence;
import org.sonar.java.resolve.SemanticModel;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ArrayAccessExpressionTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1643", name="Strings should not be concatenated using '+' in a loop", tags={"performance"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="MEMORY_EFFICIENCY")
@SqaleConstantRemediation(value="10min")
public class StringConcatenationInLoopCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;
    private Deque<Tree> loopLevel = new LinkedList<Tree>();
    private SemanticModel semanticModel;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.loopLevel.clear();
        this.semanticModel = (SemanticModel)context.getSemanticModel();
        this.scan((Tree)context.getTree());
    }

    public void visitAssignmentExpression(AssignmentExpressionTree tree) {
        if (!this.loopLevel.isEmpty() && this.isStringConcatenation(tree) && this.isNotLoopLocalVar(tree)) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Use a StringBuilder instead.");
        }
        super.visitAssignmentExpression(tree);
    }

    private boolean isNotLoopLocalVar(AssignmentExpressionTree tree) {
        IdentifierTree idTree = this.getIdentifierTree(tree.variable());
        Tree envTree = this.semanticModel.getTree(this.semanticModel.getEnv(idTree.symbol()));
        Tree loopTree = this.loopLevel.peek();
        return envTree == null || !envTree.equals(loopTree) && !envTree.equals(this.loopStatement(loopTree));
    }

    private IdentifierTree getIdentifierTree(ExpressionTree tree) {
        IdentifierTree idTree = tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? this.getIdentifierTree(((MemberSelectExpressionTree)tree).expression()) : (tree.is(new Tree.Kind[]{Tree.Kind.ARRAY_ACCESS_EXPRESSION}) ? this.getIdentifierTree(((ArrayAccessExpressionTree)tree).expression()) : (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) ? this.getIdentifierTree(((MethodInvocationTree)tree).methodSelect()) : (IdentifierTree)tree));
        return idTree;
    }

    private Tree loopStatement(Tree loopTree) {
        if (loopTree.is(new Tree.Kind[]{Tree.Kind.FOR_STATEMENT})) {
            return ((ForStatementTree)loopTree).statement();
        }
        if (loopTree.is(new Tree.Kind[]{Tree.Kind.DO_STATEMENT})) {
            return ((DoWhileStatementTree)loopTree).statement();
        }
        if (loopTree.is(new Tree.Kind[]{Tree.Kind.WHILE_STATEMENT})) {
            return ((WhileStatementTree)loopTree).statement();
        }
        if (loopTree.is(new Tree.Kind[]{Tree.Kind.FOR_EACH_STATEMENT})) {
            return ((ForEachStatement)loopTree).statement();
        }
        return null;
    }

    private boolean isStringConcatenation(AssignmentExpressionTree tree) {
        return this.isString(tree.symbolType()) && this.isConcatenation(tree);
    }

    private boolean isConcatenation(AssignmentExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.PLUS_ASSIGNMENT}) || tree.is(new Tree.Kind[]{Tree.Kind.ASSIGNMENT}) && this.removeParenthesis((Tree)tree.expression()).is(new Tree.Kind[]{Tree.Kind.PLUS}) && this.concatenateVariable(tree.variable(), (BinaryExpressionTree)this.removeParenthesis((Tree)tree.expression()));
    }

    private boolean concatenateVariable(ExpressionTree variable, BinaryExpressionTree plus) {
        return this.concatenateVariable(variable, plus.leftOperand()) || this.concatenateVariable(variable, plus.rightOperand());
    }

    private boolean concatenateVariable(ExpressionTree variable, ExpressionTree operand) {
        if (operand.is(new Tree.Kind[]{Tree.Kind.PLUS})) {
            return this.concatenateVariable(variable, (BinaryExpressionTree)operand);
        }
        return SyntacticEquivalence.areEquivalent((Tree)variable, (Tree)operand);
    }

    private Tree removeParenthesis(Tree tree) {
        Tree result = tree;
        while (result.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            result = ((ParenthesizedTree)result).expression();
        }
        return result;
    }

    private boolean isString(Type type) {
        return type.is("java.lang.String");
    }

    public void visitForEachStatement(ForEachStatement tree) {
        this.loopLevel.push((Tree)tree);
        super.visitForEachStatement(tree);
        this.loopLevel.pop();
    }

    public void visitForStatement(ForStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitForStatement(tree);
        this.loopLevel.pop();
    }

    public void visitWhileStatement(WhileStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitWhileStatement(tree);
        this.loopLevel.pop();
    }

    public void visitDoWhileStatement(DoWhileStatementTree tree) {
        this.loopLevel.push((Tree)tree);
        super.visitDoWhileStatement(tree);
        this.loopLevel.pop();
    }
}

