/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.sonar.sslr.api.AstNode;
import com.sonar.sslr.api.AstNodeType;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CodeCheck;
import org.sonar.squidbridge.checks.SquidCheck;
import org.sonar.sslr.parser.LexerlessGrammar;

@Rule(key="StringEqualityComparisonCheck", name="Strings should be compared using \"equals()\"", tags={"bug", "cwe"}, status="DEPRECATED", priority=Priority.CRITICAL)
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class StringEqualityComparisonCheck
extends SquidCheck<LexerlessGrammar>
implements JavaCheck {
    public void init() {
        this.subscribeTo(new AstNodeType[]{Tree.Kind.EQUAL_TO});
        this.subscribeTo(new AstNodeType[]{Tree.Kind.NOT_EQUAL_TO});
    }

    public void visitNode(AstNode node) {
        if (StringEqualityComparisonCheck.hasStringLiteralOperand(node)) {
            this.getContext().createLineViolation((CodeCheck)this, "Replace \"==\" and \"!=\" by \"equals()\" and \"!equals()\" respectively to compare these strings.", node, new Object[0]);
        }
    }

    private static boolean hasStringLiteralOperand(AstNode node) {
        return node.select().children((AstNodeType)Tree.Kind.STRING_LITERAL).isNotEmpty();
    }
}

