/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.HashMultiset;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import java.util.Map;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleLinearWithOffsetRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1192", name="String literals should not be duplicated", tags={"design"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleLinearWithOffsetRemediation(coeff="2min", offset="2min", effortToFixDescription="number of duplicate instances")
public class StringLiteralDuplicatedCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final int DEFAULT_THRESHOLD = 3;
    private static final Integer MINIMAL_LITERAL_LENGTH = 7;
    @RuleProperty(key="threshold", description="Number of times a literal must be duplicated to trigger an issue", defaultValue="3")
    public int threshold = 3;
    private final Map<String, LiteralTree> firstOccurrence = Maps.newHashMap();
    private final Multiset<String> occurences = HashMultiset.create();

    public void scanFile(JavaFileScannerContext context) {
        this.firstOccurrence.clear();
        this.occurences.clear();
        this.scan((Tree)context.getTree());
        for (String literal : this.occurences.elementSet()) {
            int literalOccurence = this.occurences.count((Object)literal);
            if (literalOccurence < this.threshold) continue;
            context.addIssue((Tree)this.firstOccurrence.get(literal), (JavaCheck)this, "Define a constant instead of duplicating this literal " + literal + " " + literalOccurence + " times.", Double.valueOf(literalOccurence));
        }
    }

    public void visitLiteral(LiteralTree tree) {
        String literal;
        if (tree.is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL}) && (literal = tree.value()).length() >= MINIMAL_LITERAL_LENGTH) {
            if (!this.firstOccurrence.containsKey(literal)) {
                this.firstOccurrence.put(literal, tree);
            }
            this.occurences.add((Object)literal);
        }
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
    }
}

