/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.sonar.sslr.api.Trivia;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1151", name="\"switch case\" clauses should not have too many lines", tags={"brain-overload"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
public class SwitchCaseTooBigCheck
extends SubscriptionBaseVisitor {
    private static final int DEFAULT_MAX = 5;
    @RuleProperty(defaultValue="5", description="Maximum number of lines")
    public int max = 5;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SWITCH_STATEMENT);
    }

    public void visitNode(Tree tree) {
        SwitchStatementTree switchStatementTree = (SwitchStatementTree)tree;
        for (CaseGroupTree caseGroupTree : switchStatementTree.cases()) {
            List labels = caseGroupTree.labels();
            for (int i = 0; i < labels.size() - 1; ++i) {
                CaseLabelTree currentLabel = (CaseLabelTree)labels.get(i);
                int caseStartLine = this.line((Tree)currentLabel);
                int nextCaseStartLine = this.line((Tree)labels.get(i + 1));
                this.check(currentLabel, caseStartLine, nextCaseStartLine);
            }
            CaseLabelTree lastLabel = (CaseLabelTree)Iterables.getLast((Iterable)labels);
            int startLine = Math.min(this.line((Tree)lastLabel) + 1, this.firstStatementLine(caseGroupTree.body()));
            int endLine = this.getNextLine(switchStatementTree, caseGroupTree);
            this.check(lastLabel, startLine, endLine);
        }
    }

    private int firstStatementLine(List<StatementTree> body) {
        if (!body.isEmpty()) {
            StatementTree firstStatement = body.get(0);
            int firstStatementLine = this.line((Tree)body.get(0));
            List trivias = ((JavaTree)firstStatement).getToken().getTrivia();
            if (!trivias.isEmpty()) {
                return Math.min(this.firstLineTrivia(trivias), firstStatementLine);
            }
            return firstStatementLine;
        }
        return Integer.MAX_VALUE;
    }

    private int firstLineTrivia(List<Trivia> trivias) {
        return trivias.get(0).getToken().getLine();
    }

    private void check(CaseLabelTree caseLabelTree, int caseStartLine, int nextCaseStartLine) {
        int lines = Math.max(nextCaseStartLine - caseStartLine, 1);
        if (lines > this.max) {
            this.addIssue((Tree)caseLabelTree, "Reduce this switch case number of lines from " + lines + " to at most " + this.max + ", for example by extracting code into methods.");
        }
    }

    private int getNextLine(SwitchStatementTree switchStatementTree, CaseGroupTree caseGroupTree) {
        int switchLastLine = this.line((Tree)switchStatementTree.closeBraceToken());
        List cases = switchStatementTree.cases();
        int indexOfCaseGroup = cases.indexOf(caseGroupTree);
        if (indexOfCaseGroup == cases.size() - 1) {
            return switchLastLine;
        }
        return this.line((Tree)cases.get(indexOfCaseGroup + 1));
    }

    private int line(Tree tree) {
        return ((JavaTree)tree).getLine();
    }
}

