/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AbstractInSynchronizeChecker;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2276", name="\"wait(...)\" should be used instead of \"Thread.sleep(...)\" when a lock is held", tags={"multi-threading", "performance"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ThreadSleepCheck
extends AbstractInSynchronizeChecker {
    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        if (this.isInSyncBlock()) {
            this.addIssue((Tree)mit, "Replace the call to \"Thread.sleep(...)\" with a call to \"wait(...)\".");
        }
    }

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.Thread").name("sleep").withNoParameterConstraint());
    }
}

