/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaSymbol;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2065", name="Fields in non-serializable classes should not be \"transient\"", tags={"serialization", "unused"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class TransientFieldInNonSerializableCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.hasSemantic() && this.isNotSerializable(classTree.symbol())) {
            for (Tree member : classTree.members()) {
                if (!this.isTransient(member)) continue;
                this.addIssue(member, "Remove the \"transient\" modifier from this field.");
            }
        }
    }

    private boolean isNotSerializable(Symbol.TypeSymbol symbol) {
        for (Type superType : ((JavaSymbol.TypeJavaSymbol)symbol).superTypes()) {
            if (!superType.isUnknown()) continue;
            return false;
        }
        return !symbol.type().isSubtypeOf("java.io.Serializable");
    }

    private boolean isTransient(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variable = (VariableTree)tree;
            return variable.modifiers().modifiers().contains(Modifier.TRANSIENT);
        }
        return false;
    }
}

