/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1068", name="Unused private fields should be removed", tags={"unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class UnusedPrivateFieldCheck
extends SubscriptionBaseVisitor {
    private static final String LOMBOK_GETTER = "lombok.Getter";
    private static final Tree.Kind[] ASSIGNMENT_KINDS = new Tree.Kind[]{Tree.Kind.ASSIGNMENT, Tree.Kind.MULTIPLY_ASSIGNMENT, Tree.Kind.DIVIDE_ASSIGNMENT, Tree.Kind.REMAINDER_ASSIGNMENT, Tree.Kind.PLUS_ASSIGNMENT, Tree.Kind.MINUS_ASSIGNMENT, Tree.Kind.LEFT_SHIFT_ASSIGNMENT, Tree.Kind.RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.UNSIGNED_RIGHT_SHIFT_ASSIGNMENT, Tree.Kind.AND_ASSIGNMENT, Tree.Kind.XOR_ASSIGNMENT, Tree.Kind.OR_ASSIGNMENT};
    private List<ClassTree> classes = Lists.newArrayList();
    private ListMultimap<Symbol, IdentifierTree> assignments = ArrayListMultimap.create();
    private boolean hasNativeMethod = false;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.COMPILATION_UNIT, (Object)Tree.Kind.METHOD, (Object)Tree.Kind.EXPRESSION_STATEMENT);
    }

    public void leaveNode(Tree tree) {
        if (this.hasSemantic()) {
            if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
                MethodTree method = (MethodTree)tree;
                if (method.modifiers().modifiers().contains(Modifier.NATIVE)) {
                    this.hasNativeMethod = true;
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
                this.classes.add((ClassTree)tree);
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT})) {
                ExpressionTree expression = ((ExpressionStatementTree)tree).expression();
                if (expression.is(ASSIGNMENT_KINDS)) {
                    this.addAssignment(((AssignmentExpressionTree)expression).variable());
                }
            } else {
                this.leaveCompilationUnit();
            }
        }
    }

    private void leaveCompilationUnit() {
        if (!this.hasNativeMethod) {
            for (ClassTree classTree : this.classes) {
                this.checkClassFields(classTree);
            }
        }
        this.classes.clear();
        this.assignments.clear();
        this.hasNativeMethod = false;
    }

    private void checkClassFields(ClassTree classTree) {
        if (!this.hasAnnotation(classTree.modifiers(), LOMBOK_GETTER)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
                this.checkIfUnused((VariableTree)member);
            }
        }
    }

    public void checkIfUnused(VariableTree tree) {
        Symbol symbol;
        if (tree.modifiers().modifiers().contains(Modifier.PRIVATE) && !"serialVersionUID".equals(tree.simpleName().name()) && (symbol = tree.symbol()).usages().size() == this.assignments.get((Object)symbol).size() && !this.hasExcludedAnnotation(tree)) {
            this.addIssue((Tree)tree, "Remove this unused \"" + tree.simpleName() + "\" private field.");
        }
    }

    private boolean hasExcludedAnnotation(VariableTree tree) {
        ModifiersTree modifiers = tree.modifiers();
        return this.hasAnnotation(modifiers, LOMBOK_GETTER) || this.hasAnnotation(modifiers, "javax.enterprise.inject.Produces");
    }

    private boolean hasAnnotation(ModifiersTree modifiers, String annotationName) {
        for (AnnotationTree annotation : modifiers.annotations()) {
            if (!annotation.symbolType().is(annotationName)) continue;
            return true;
        }
        return false;
    }

    private void addAssignment(ExpressionTree variable) {
        if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            this.addAssignment((IdentifierTree)variable);
        } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            this.addAssignment(((MemberSelectExpressionTree)variable).identifier());
        }
    }

    private void addAssignment(IdentifierTree identifier) {
        Symbol reference = identifier.symbol();
        if (!reference.isUnknown()) {
            this.assignments.put((Object)reference, (Object)identifier);
        }
    }
}

