/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks.methods;

import com.google.common.collect.Lists;
import java.util.List;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;

public class MethodInvocationMatcherCollection {
    private List<MethodInvocationMatcher> matchers = Lists.newLinkedList();

    private MethodInvocationMatcherCollection() {
    }

    public static MethodInvocationMatcherCollection create() {
        return new MethodInvocationMatcherCollection();
    }

    public static MethodInvocationMatcherCollection create(MethodInvocationMatcher ... matchers) {
        MethodInvocationMatcherCollection collection = new MethodInvocationMatcherCollection();
        for (MethodInvocationMatcher matcher : matchers) {
            collection.matchers.add(matcher);
        }
        return collection;
    }

    public MethodInvocationMatcherCollection add(MethodInvocationMatcher matcher) {
        this.matchers.add(matcher);
        return this;
    }

    public boolean anyMatch(MethodInvocationTree mit) {
        for (MethodInvocationMatcher matcher : this.matchers) {
            if (!matcher.matches(mit)) continue;
            return true;
        }
        return false;
    }
}

