/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.Collection;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1694", name="An abstract class should have both abstract and concrete methods", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class AbstractClassWithoutAbstractMethodCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        Symbol.TypeSymbol typeSymbol;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) && (typeSymbol = tree.symbol()) != null && typeSymbol.isAbstract()) {
            Collection symbols = typeSymbol.memberSymbols();
            int abstractMethod = this.countAbstractMethods(symbols);
            if (this.isExtendingObject(tree) && abstractMethod == symbols.size() - 2) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Convert this \"" + typeSymbol + "\" class to an interface");
            }
            if (symbols.size() > 2 && abstractMethod == 0 && !this.isPartialImplementation(tree)) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Convert this \"" + typeSymbol + "\" class to a concrete class with a private constructor");
            }
        }
        super.visitClass(tree);
    }

    private boolean isExtendingObject(ClassTree tree) {
        TypeTree superClass = tree.superClass();
        return superClass == null || superClass.symbolType().is("java.lang.Object");
    }

    private boolean isPartialImplementation(ClassTree tree) {
        return tree.superClass() != null || !tree.superInterfaces().isEmpty();
    }

    private int countAbstractMethods(Collection<? extends Symbol> symbols) {
        int abstractMethod = 0;
        for (Symbol symbol : symbols) {
            if (!this.isAbstractMethod(symbol)) continue;
            ++abstractMethod;
        }
        return abstractMethod;
    }

    private boolean isAbstractMethod(Symbol sym) {
        return sym.isMethodSymbol() && sym.isAbstract();
    }
}

