/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;

public abstract class AbstractInSynchronizeChecker
extends AbstractMethodDetection {
    private Deque<Boolean> withinSynchronizedBlock = Lists.newLinkedList();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.withinSynchronizedBlock.push(false);
        super.scanFile(context);
        this.withinSynchronizedBlock.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.SYNCHRONIZED_STATEMENT, (Object)Tree.Kind.METHOD);
    }

    @Override
    public void visitNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            super.visitNode(tree);
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD})) {
            this.withinSynchronizedBlock.push(((MethodTree)tree).modifiers().modifiers().contains(Modifier.SYNCHRONIZED));
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            this.withinSynchronizedBlock.push(true);
        }
    }

    public void leaveNode(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD, Tree.Kind.SYNCHRONIZED_STATEMENT})) {
            this.withinSynchronizedBlock.pop();
        }
    }

    public boolean isInSyncBlock() {
        return this.withinSynchronizedBlock.peek();
    }

    public boolean hasAnyParentSync() {
        return this.withinSynchronizedBlock.contains(true);
    }
}

