/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2116", name="\"hashCode\" and \"toString\" should not be called on array instances", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class ArrayHashCodeAndToStringCheck
extends AbstractMethodDetection {
    private static final TypeCriteria IS_ARRAY = new IsArrayCriteria();

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.arrayMethodInvocation("toString"), (Object)this.arrayMethodInvocation("hashCode"));
    }

    private MethodInvocationMatcher arrayMethodInvocation(String methodName) {
        return MethodInvocationMatcher.create().callSite(IS_ARRAY).name(methodName);
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        String methodName = mit.symbol().name();
        this.addIssue((Tree)mit, "Use \"Arrays." + methodName + "(array)\" instead.");
    }

    private static class IsArrayCriteria
    extends TypeCriteria {
        private IsArrayCriteria() {
        }

        @Override
        public boolean matches(Type type) {
            return type.isArray();
        }
    }
}

