/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="ClassVariableVisibilityCheck", name="Class variable fields should not have public accessibility", tags={"cwe"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class ClassVariableVisibilityCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private Deque<Boolean> isClassStack = new ArrayDeque<Boolean>();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitClass(ClassTree tree) {
        this.isClassStack.push(tree.is(new Tree.Kind[]{Tree.Kind.CLASS}) || tree.is(new Tree.Kind[]{Tree.Kind.ENUM}));
        super.visitClass(tree);
        this.isClassStack.pop();
    }

    public void visitVariable(VariableTree tree) {
        List modifiers = tree.modifiers().modifiers();
        List annotations = tree.modifiers().annotations();
        if (this.isClass() && ClassVariableVisibilityCheck.isPublic(modifiers) && !ClassVariableVisibilityCheck.isConstant(modifiers) && annotations.isEmpty()) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Make " + tree.simpleName() + " a static final constant or non-public and provide accessors if needed.");
        }
        super.visitVariable(tree);
    }

    private boolean isClass() {
        return !this.isClassStack.isEmpty() && this.isClassStack.peek() != false;
    }

    private static boolean isConstant(List<Modifier> modifiers) {
        return !modifiers.isEmpty() && modifiers.contains(Modifier.FINAL) && modifiers.contains(Modifier.STATIC);
    }

    private static boolean isPublic(List<Modifier> modifiers) {
        return !modifiers.isEmpty() && modifiers.contains(Modifier.PUBLIC);
    }
}

