/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.MethodInvocationMatcherCollection;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.IssuableSubscriptionVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.CaseLabelTree;
import org.sonar.plugins.java.api.tree.CatchTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.DoWhileStatementTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ForEachStatement;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ReturnStatementTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.SwitchStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.TryStatementTree;
import org.sonar.plugins.java.api.tree.TypeCastTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.plugins.java.api.tree.WhileStatementTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2095", name="Resources should be closed", tags={"bug", "cert", "cwe", "denial-of-service", "leak", "security"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="5min")
public class CloseResourceCheck
extends SubscriptionBaseVisitor {
    private static final String[] IGNORED_CLOSEABLE_SUBTYPES = new String[]{"java.io.ByteArrayOutputStream", "java.io.ByteArrayInputStream", "java.io.StringReader", "java.io.StringWriter", "java.io.CharArraReader", "java.io.CharArrayWriter"};
    private static final String CLOSE_METHOD_NAME = "close";
    private static final String JAVA_IO_CLOSEABLE = "java.io.Closeable";
    private static final String JAVA_LANG_AUTOCLOSEABLE = "java.lang.AutoCloseable";
    private static final MethodInvocationMatcherCollection CLOSE_INVOCATIONS = CloseResourceCheck.closeMethodInvocationMatcher();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        BlockTree block = methodTree.block();
        if (block != null) {
            CloseableVisitor visitor = new CloseableVisitor(methodTree.parameters(), this);
            block.accept((TreeVisitor)visitor);
            visitor.executionState.insertIssues();
        }
    }

    private static MethodInvocationMatcherCollection closeMethodInvocationMatcher() {
        return MethodInvocationMatcherCollection.create(MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf(JAVA_IO_CLOSEABLE)).name(CLOSE_METHOD_NAME).withNoParameterConstraint(), MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf(JAVA_LANG_AUTOCLOSEABLE)).name(CLOSE_METHOD_NAME).withNoParameterConstraint());
    }

    private static boolean isCloseableOrAutoCloseableSubtype(Type type) {
        return type.isSubtypeOf(JAVA_IO_CLOSEABLE) || type.isSubtypeOf(JAVA_LANG_AUTOCLOSEABLE);
    }

    private static boolean isIgnoredCloseableSubtype(Type type) {
        for (String fullyQualifiedName : IGNORED_CLOSEABLE_SUBTYPES) {
            if (!type.isSubtypeOf(fullyQualifiedName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isSubclassOfInputStreamOrOutputStreamWithoutClose(Type type) {
        Symbol.TypeSymbol typeSymbol = type.symbol();
        Type superClass = typeSymbol.superClass();
        if (superClass != null && (superClass.is("java.io.OutputStream") || superClass.is("java.io.InputStream"))) {
            return typeSymbol.lookupSymbols(CLOSE_METHOD_NAME).isEmpty();
        }
        return false;
    }

    private static class ExecutionState {
        @Nullable
        private ExecutionState parent;
        private Map<Symbol, CloseableOccurence> closeableOccurenceBySymbol = Maps.newHashMap();
        private IssuableSubscriptionVisitor check;

        ExecutionState(Set<Symbol> excludedCloseables, IssuableSubscriptionVisitor check) {
            this.check = check;
            for (Symbol symbol : excludedCloseables) {
                this.closeableOccurenceBySymbol.put(symbol, CloseableOccurence.IGNORED);
            }
        }

        public ExecutionState(ExecutionState parent) {
            this.parent = parent;
            this.check = parent.check;
        }

        public ExecutionState merge(ExecutionState executionState) {
            for (Map.Entry<Symbol, CloseableOccurence> entry : executionState.closeableOccurenceBySymbol.entrySet()) {
                Symbol symbol = entry.getKey();
                CloseableOccurence currentOccurence = this.getCloseableOccurence(symbol);
                CloseableOccurence occurenceToMerge = entry.getValue();
                if (currentOccurence != null) {
                    currentOccurence.state = currentOccurence.state.merge(occurenceToMerge.state);
                    this.closeableOccurenceBySymbol.put(symbol, currentOccurence);
                    continue;
                }
                if (!occurenceToMerge.state.isOpen()) continue;
                this.insertIssue(occurenceToMerge.lastAssignment);
            }
            return this;
        }

        public ExecutionState overrideBy(ExecutionState currentES) {
            for (Map.Entry<Symbol, CloseableOccurence> entry : currentES.closeableOccurenceBySymbol.entrySet()) {
                Symbol symbol = entry.getKey();
                CloseableOccurence occurence = entry.getValue();
                if (this.getCloseableOccurence(symbol) != null) {
                    this.markAs(symbol, occurence.state);
                    continue;
                }
                this.closeableOccurenceBySymbol.put(symbol, occurence);
            }
            return this;
        }

        public ExecutionState restoreParent() {
            if (this.parent != null) {
                this.insertIssues();
                return this.parent.merge(this);
            }
            return this;
        }

        private void insertIssues() {
            for (Tree tree : this.getUnclosedClosables()) {
                this.insertIssue(tree);
            }
        }

        private void insertIssue(Tree tree) {
            Type type = tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) ? ((VariableTree)tree).symbol().type() : ((IdentifierTree)tree).symbol().type();
            this.check.addIssue(tree, "Close this \"" + type.name() + "\"");
        }

        private void addCloseable(Symbol symbol, Tree lastAssignmentTree, @Nullable ExpressionTree assignmentExpression) {
            CloseableOccurence newOccurence = new CloseableOccurence(lastAssignmentTree, this.getCloseableStateFromExpression(symbol, assignmentExpression));
            CloseableOccurence knownOccurence = this.getCloseableOccurence(symbol);
            if (knownOccurence != null) {
                CloseableOccurence currentOccurence = this.closeableOccurenceBySymbol.get(symbol);
                if (currentOccurence != null && currentOccurence.state.isOpen()) {
                    this.insertIssue(knownOccurence.lastAssignment);
                }
                if (!knownOccurence.state.isIgnored()) {
                    this.closeableOccurenceBySymbol.put(symbol, newOccurence);
                }
            } else {
                this.closeableOccurenceBySymbol.put(symbol, newOccurence);
            }
        }

        private State getCloseableStateFromExpression(Symbol symbol, @Nullable ExpressionTree expression) {
            if (ExecutionState.shouldBeIgnored(symbol, expression)) {
                return State.IGNORED;
            }
            if (ExecutionState.isNull(expression)) {
                return State.NULL;
            }
            if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                if (this.usesIgnoredCloseableAsArgument(((NewClassTree)expression).arguments())) {
                    return State.IGNORED;
                }
                return State.OPEN;
            }
            return State.IGNORED;
        }

        private static boolean isNull(ExpressionTree expression) {
            return expression == null || expression.is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        }

        private static boolean shouldBeIgnored(Symbol symbol, @Nullable ExpressionTree expression) {
            return ExecutionState.shouldBeIgnored(symbol) || ExecutionState.shouldBeIgnored(expression);
        }

        private static boolean shouldBeIgnored(Symbol symbol) {
            return symbol.isFinal() || CloseResourceCheck.isIgnoredCloseableSubtype(symbol.type()) || CloseResourceCheck.isSubclassOfInputStreamOrOutputStreamWithoutClose(symbol.type());
        }

        private static boolean shouldBeIgnored(@Nullable ExpressionTree expression) {
            return expression != null && CloseResourceCheck.isSubclassOfInputStreamOrOutputStreamWithoutClose(expression.symbolType());
        }

        private boolean usesIgnoredCloseableAsArgument(List<ExpressionTree> arguments) {
            for (ExpressionTree argument : arguments) {
                if (this.isNewClassWithIgnoredArguments(argument)) {
                    return true;
                }
                if (this.isMethodInvocationWithIgnoredArguments(argument)) {
                    return true;
                }
                if (!this.useIgnoredCloseable(argument) && !CloseResourceCheck.isSubclassOfInputStreamOrOutputStreamWithoutClose(argument.symbolType())) continue;
                return true;
            }
            return false;
        }

        private boolean isNewClassWithIgnoredArguments(ExpressionTree argument) {
            return argument.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) && this.usesIgnoredCloseableAsArgument(((NewClassTree)argument).arguments());
        }

        private boolean isMethodInvocationWithIgnoredArguments(ExpressionTree argument) {
            return argument.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && this.usesIgnoredCloseableAsArgument(((MethodInvocationTree)argument).arguments());
        }

        private boolean useIgnoredCloseable(ExpressionTree expression) {
            IdentifierTree identifier;
            return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT}) && this.isIgnoredCloseable((identifier = expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) ? ((MemberSelectExpressionTree)expression).identifier() : (IdentifierTree)expression).symbol());
        }

        private boolean isIgnoredCloseable(Symbol symbol) {
            if (CloseResourceCheck.isCloseableOrAutoCloseableSubtype(symbol.type()) && !symbol.owner().isMethodSymbol()) {
                return true;
            }
            CloseableOccurence currentOccurence = this.getCloseableOccurence(symbol);
            return currentOccurence != null && currentOccurence.state.isIgnored();
        }

        private void checkUsageOfClosables(List<ExpressionTree> expressions) {
            for (ExpressionTree expression : expressions) {
                this.checkUsageOfClosables(expression);
            }
        }

        private void checkUsageOfClosables(@Nullable ExpressionTree expression) {
            if (expression != null) {
                if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && CloseResourceCheck.isCloseableOrAutoCloseableSubtype(expression.symbolType())) {
                    this.markAsIgnored(((IdentifierTree)expression).symbol());
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    this.checkUsageOfClosables((ExpressionTree)((MemberSelectExpressionTree)expression).identifier());
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.TYPE_CAST})) {
                    this.checkUsageOfClosables(((TypeCastTree)expression).expression());
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                    this.checkUsageOfClosables(((MethodInvocationTree)expression).arguments());
                } else if (expression.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
                    this.checkUsageOfClosables(((NewClassTree)expression).arguments());
                }
            }
        }

        private void markAsIgnored(Symbol symbol) {
            this.markAs(symbol, State.IGNORED);
        }

        private void markAsClosed(Symbol symbol) {
            this.markAs(symbol, State.CLOSED);
        }

        private void markAs(Symbol symbol, State state) {
            CloseableOccurence occurence;
            if (this.closeableOccurenceBySymbol.containsKey(symbol)) {
                this.closeableOccurenceBySymbol.get(symbol).state = state;
            } else if (this.parent != null && (occurence = this.getCloseableOccurence(symbol)) != null) {
                occurence.state = state;
                this.closeableOccurenceBySymbol.put(symbol, occurence);
            }
        }

        private Set<Tree> getUnclosedClosables() {
            HashSet results = Sets.newHashSet();
            for (CloseableOccurence occurence : this.closeableOccurenceBySymbol.values()) {
                if (!occurence.state.isOpen()) continue;
                results.add(occurence.lastAssignment);
            }
            return results;
        }

        @CheckForNull
        private CloseableOccurence getCloseableOccurence(Symbol symbol) {
            CloseableOccurence occurence = this.closeableOccurenceBySymbol.get(symbol);
            if (occurence != null) {
                return new CloseableOccurence(occurence.lastAssignment, occurence.state);
            }
            if (this.parent != null) {
                return this.parent.getCloseableOccurence(symbol);
            }
            return null;
        }
    }

    private static class CloseableOccurence {
        private static final CloseableOccurence IGNORED = new CloseableOccurence(null, State.IGNORED);
        @Nullable
        private Tree lastAssignment;
        private State state;

        public CloseableOccurence(@Nullable Tree lastAssignment, State state) {
            this.lastAssignment = lastAssignment;
            this.state = state;
        }
    }

    private static class CloseableVisitor
    extends BaseTreeVisitor {
        private ExecutionState executionState;

        public CloseableVisitor(List<VariableTree> methodParameters, SubscriptionBaseVisitor check) {
            this.executionState = new ExecutionState(this.extractCloseableSymbols(methodParameters), check);
        }

        public void visitVariable(VariableTree tree) {
            ExpressionTree initializer = tree.initializer();
            this.executionState.checkUsageOfClosables(initializer);
            Symbol symbol = tree.symbol();
            if (CloseResourceCheck.isCloseableOrAutoCloseableSubtype(symbol.type())) {
                this.executionState.addCloseable(symbol, (Tree)tree, initializer);
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            ExpressionTree variable = tree.variable();
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER, Tree.Kind.MEMBER_SELECT})) {
                ExpressionTree expression = tree.expression();
                this.executionState.checkUsageOfClosables(expression);
                IdentifierTree identifier = variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) ? (IdentifierTree)variable : ((MemberSelectExpressionTree)variable).identifier();
                Symbol symbol = identifier.symbol();
                if (CloseResourceCheck.isCloseableOrAutoCloseableSubtype(identifier.symbolType()) && symbol.owner().isMethodSymbol()) {
                    this.executionState.addCloseable(symbol, (Tree)identifier, expression);
                }
            }
        }

        public void visitNewClass(NewClassTree tree) {
            this.executionState.checkUsageOfClosables(tree.arguments());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (CLOSE_INVOCATIONS.anyMatch(tree)) {
                ExpressionTree methodSelect = tree.methodSelect();
                if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                    ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
                    if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                        this.executionState.markAsClosed(((IdentifierTree)expression).symbol());
                    }
                }
            } else {
                this.executionState.checkUsageOfClosables(tree.arguments());
            }
        }

        public void visitClass(ClassTree tree) {
        }

        public void visitReturnStatement(ReturnStatementTree tree) {
            this.executionState.checkUsageOfClosables(tree.expression());
        }

        public void visitTryStatement(TryStatementTree tree) {
            ExecutionState blockES;
            for (VariableTree resource : tree.resources()) {
                this.executionState.markAsIgnored(resource.symbol());
            }
            this.executionState = blockES = new ExecutionState(this.executionState);
            this.scan((Tree)tree.block());
            for (CatchTree catchTree : tree.catches()) {
                this.executionState = new ExecutionState(blockES.parent);
                this.scan((Tree)catchTree.block());
                blockES.merge(this.executionState);
            }
            if (tree.finallyBlock() != null) {
                this.executionState = new ExecutionState(blockES.parent);
                this.scan((Tree)tree.finallyBlock());
                this.executionState = blockES.parent.overrideBy(blockES.overrideBy(this.executionState));
            } else {
                this.executionState = blockES.parent.merge(blockES);
            }
        }

        public void visitIfStatement(IfStatementTree tree) {
            ExecutionState thenES;
            this.scan((Tree)tree.condition());
            this.executionState = thenES = new ExecutionState(this.executionState);
            this.scan((Tree)tree.thenStatement());
            if (tree.elseStatement() == null) {
                this.executionState = thenES.parent.merge(thenES);
            } else {
                ExecutionState elseES;
                this.executionState = elseES = new ExecutionState(thenES.parent);
                this.scan((Tree)tree.elseStatement());
                this.executionState = thenES.parent.overrideBy(thenES.merge(elseES));
            }
        }

        public void visitSwitchStatement(SwitchStatementTree tree) {
            this.scan((Tree)tree.expression());
            ExecutionState resultingES = new ExecutionState(this.executionState);
            this.executionState = new ExecutionState(this.executionState);
            for (CaseGroupTree caseGroupTree : tree.cases()) {
                for (StatementTree statement : caseGroupTree.body()) {
                    if (this.isBreakOrReturnStatement(statement)) {
                        resultingES = this.executionState.merge(resultingES);
                        this.executionState = new ExecutionState(resultingES.parent);
                        continue;
                    }
                    this.scan((Tree)statement);
                }
            }
            if (!this.lastStatementIsBreakOrReturn(tree)) {
                resultingES = this.executionState.merge(resultingES);
            }
            this.executionState = this.switchContainsDefaultLabel(tree) ? resultingES.parent.overrideBy(resultingES) : resultingES.parent.merge(resultingES);
        }

        private boolean isBreakOrReturnStatement(StatementTree statement) {
            return statement.is(new Tree.Kind[]{Tree.Kind.BREAK_STATEMENT, Tree.Kind.RETURN_STATEMENT});
        }

        private boolean switchContainsDefaultLabel(SwitchStatementTree tree) {
            for (CaseGroupTree caseGroupTree : tree.cases()) {
                for (CaseLabelTree label : caseGroupTree.labels()) {
                    if (!"default".equals(label.caseOrDefaultKeyword().text())) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean lastStatementIsBreakOrReturn(SwitchStatementTree tree) {
            List cases = tree.cases();
            if (!cases.isEmpty()) {
                List lastStatements = ((CaseGroupTree)cases.get(cases.size() - 1)).body();
                return !lastStatements.isEmpty() && this.isBreakOrReturnStatement((StatementTree)lastStatements.get(lastStatements.size() - 1));
            }
            return false;
        }

        public void visitWhileStatement(WhileStatementTree tree) {
            this.scan((Tree)tree.condition());
            this.visitStatement(tree.statement());
        }

        public void visitDoWhileStatement(DoWhileStatementTree tree) {
            this.visitStatement(tree.statement());
            this.scan((Tree)tree.condition());
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan((Tree)tree.condition());
            this.scan(tree.initializer());
            this.scan(tree.update());
            this.visitStatement(tree.statement());
        }

        public void visitForEachStatement(ForEachStatement tree) {
            this.scan((Tree)tree.variable());
            this.scan((Tree)tree.expression());
            this.visitStatement(tree.statement());
        }

        private void visitStatement(StatementTree tree) {
            this.executionState = new ExecutionState(this.executionState);
            this.scan((Tree)tree);
            this.executionState = this.executionState.restoreParent();
        }

        private Set<Symbol> extractCloseableSymbols(List<VariableTree> variableTrees) {
            HashSet symbols = Sets.newHashSet();
            for (VariableTree variableTree : variableTrees) {
                Symbol symbol = variableTree.symbol();
                if (!CloseResourceCheck.isCloseableOrAutoCloseableSubtype(symbol.type())) continue;
                symbols.add(symbol);
            }
            return symbols;
        }
    }

    private static enum State {
        NULL{

            @Override
            public State merge(State s) {
                return s;
            }
        }
        ,
        CLOSED{

            @Override
            public State merge(State s) {
                if (s == NULL) {
                    return this;
                }
                return s;
            }
        }
        ,
        OPEN{

            @Override
            public State merge(State s) {
                if (s == IGNORED) {
                    return s;
                }
                return this;
            }
        }
        ,
        IGNORED{

            @Override
            public State merge(State s) {
                return this;
            }
        };


        public abstract State merge(State var1);

        public boolean isIgnored() {
            return this.equals((Object)IGNORED);
        }

        public boolean isOpen() {
            return this.equals((Object)OPEN);
        }
    }
}

