/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.model.expression.NewClassTreeImpl;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1943", name="Classes and methods that rely on the default system encoding should not be used", tags={"bug"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class DefaultEncodingUsageCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String BOOLEAN = "boolean";
    private static final String BYTE_ARRAY = "byte[]";
    private static final String JAVA_IO_FILE = "java.io.File";
    private static final String JAVA_IO_FILEWRITER = "java.io.FileWriter";
    private static final String JAVA_IO_FILEREADER = "java.io.FileReader";
    private static final String JAVA_IO_PRINTWRITER = "java.io.PrintWriter";
    private static final String JAVA_IO_PRINTSTREAM = "java.io.PrintStream";
    private static final String JAVA_IO_INPUTSTREAM = "java.io.InputStream";
    private static final String JAVA_IO_OUTPUTSTREAM = "java.io.OutputStream";
    private static final String JAVA_IO_BYTEARRAYOUTPUTSTREAM = "java.io.ByteArrayOutputStream";
    private static final String JAVA_IO_OUTPUTSTREAMWRITER = "java.io.OutputStreamWriter";
    private static final String JAVA_IO_INPUTSTREAMREADER = "java.io.InputStreamReader";
    private static final String JAVA_NIO_FILE_PATH = "java.nio.file.Path";
    private static final String JAVA_LANG_STRING = "java.lang.String";
    private static final String JAVA_UTIL_SCANNER = "java.util.Scanner";
    private static final String JAVA_UTIL_FORMATTER = "java.util.Formatter";
    private static final String[] FORBIDDEN_TYPES = new String[]{"java.io.FileReader", "java.io.FileWriter"};
    private Set<Tree> excluded = Sets.newHashSet();

    @Override
    public void scanFile(JavaFileScannerContext context) {
        super.scanFile(context);
        this.excluded.clear();
    }

    @Override
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION, (Object)Tree.Kind.NEW_CLASS, (Object)Tree.Kind.VARIABLE);
    }

    @Override
    public void visitNode(Tree tree) {
        if (!this.excluded.contains(tree)) {
            super.visitNode(tree);
            if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
                VariableTree variableTree = (VariableTree)tree;
                boolean foundIssue = this.checkForbiddenTypes(tree, variableTree.type());
                if (foundIssue) {
                    this.excluded.add((Tree)variableTree.initializer());
                }
            } else if (tree.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
                this.checkForbiddenTypes(tree, (ExpressionTree)((MethodInvocationTree)tree));
            }
        }
    }

    private boolean checkForbiddenTypes(Tree tree, TypeTree typedTree) {
        return this.checkForbiddenTypes(tree, typedTree.symbolType());
    }

    private boolean checkForbiddenTypes(Tree tree, ExpressionTree typedTree) {
        return this.checkForbiddenTypes(tree, typedTree.symbolType());
    }

    private boolean checkForbiddenTypes(Tree tree, Type symbolType) {
        boolean foundIssue = false;
        for (String forbiddenType : FORBIDDEN_TYPES) {
            if (!symbolType.is(forbiddenType)) continue;
            this.addIssue(tree, "Remove this use of \"" + forbiddenType + "\"");
            foundIssue = true;
        }
        return foundIssue;
    }

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)this.method(JAVA_LANG_STRING, "getBytes", new String[0]), (Object)this.method(JAVA_LANG_STRING, "getBytes", INT, INT, BYTE_ARRAY, INT), (Object)this.constructor(JAVA_LANG_STRING, BYTE_ARRAY), (Object)this.constructor(JAVA_LANG_STRING, BYTE_ARRAY, INT, INT), (Object)this.method(JAVA_IO_BYTEARRAYOUTPUTSTREAM, "toString", new String[0]), (Object)this.constructor(JAVA_IO_FILEREADER, new String[0]).withNoParameterConstraint(), (Object)this.constructor(JAVA_IO_FILEWRITER, new String[0]).withNoParameterConstraint(), (Object)this.constructor(JAVA_IO_INPUTSTREAMREADER, JAVA_IO_INPUTSTREAM), (Object)this.constructor(JAVA_IO_OUTPUTSTREAMWRITER, JAVA_IO_OUTPUTSTREAM), (Object)this.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_FILE), (Object)this.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_OUTPUTSTREAM), (Object)this.constructor(JAVA_IO_PRINTSTREAM, JAVA_IO_OUTPUTSTREAM, BOOLEAN), (Object[])new MethodInvocationMatcher[]{this.constructor(JAVA_IO_PRINTSTREAM, JAVA_LANG_STRING), this.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_FILE), this.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_OUTPUTSTREAM), this.constructor(JAVA_IO_PRINTWRITER, JAVA_IO_OUTPUTSTREAM, BOOLEAN), this.constructor(JAVA_IO_PRINTWRITER, JAVA_LANG_STRING), this.constructor(JAVA_UTIL_FORMATTER, JAVA_LANG_STRING), this.constructor(JAVA_UTIL_FORMATTER, JAVA_IO_FILE), this.constructor(JAVA_UTIL_FORMATTER, JAVA_IO_OUTPUTSTREAM), this.constructor(JAVA_UTIL_SCANNER, JAVA_IO_FILE), this.constructor(JAVA_UTIL_SCANNER, JAVA_NIO_FILE_PATH), this.constructor(JAVA_UTIL_SCANNER, JAVA_IO_INPUTSTREAM)});
    }

    private MethodInvocationMatcher method(String type, String methodName, String ... argTypes) {
        MethodInvocationMatcher matcher = MethodInvocationMatcher.create().typeDefinition(type).name(methodName);
        for (String argType : argTypes) {
            matcher = matcher.addParameter(argType);
        }
        return matcher;
    }

    private MethodInvocationMatcher constructor(String type, String ... argTypes) {
        return this.method(type, "<init>", argTypes);
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Remove this use of \"" + mit.symbol().name() + "\"");
    }

    @Override
    protected void onConstructorFound(NewClassTree newClassTree) {
        NewClassTreeImpl newClassTreeImpl = (NewClassTreeImpl)newClassTree;
        IdentifierTree constructorIdentifier = newClassTreeImpl.getConstructorIdentifier();
        Symbol symbol = constructorIdentifier.symbol();
        if (symbol.isMethodSymbol()) {
            Symbol.MethodSymbol constructor = (Symbol.MethodSymbol)symbol;
            String signature = constructor.owner().name() + "(" + Joiner.on((char)',').join((Iterable)constructor.parameterTypes()) + ")";
            this.addIssue((Tree)newClassTree, "Remove this use of constructor \"" + signature + "\"");
        }
    }
}

