/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1190", name="Future keywords should not be used as names", tags={"obsolete", "pitfall"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="COMPILER_RELATED_PORTABILITY")
@SqaleConstantRemediation(value="5min")
public class EnumAsIdentifierCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        if ("enum".equals(tree.simpleName().name())) {
            this.context.addIssue((Tree)tree, (JavaCheck)this, "Use a different name than \"enum\".");
        }
        super.visitVariable(tree);
    }
}

