/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ForStatementTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.UnaryExpressionTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1994", name="\"for\" loop incrementers should modify the variable being tested in the loop's stop condition", tags={"bug"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="LOGIC_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ForLoopIncrementAndUpdateCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.FOR_STATEMENT);
    }

    public void visitNode(Tree tree) {
        ForStatementTree forStatementTree;
        if (this.hasSemantic() && !(forStatementTree = (ForStatementTree)tree).update().isEmpty()) {
            Collection<Symbol> updateSymbols = this.getUpdatedSymbols(forStatementTree);
            ConditionVisitor conditionVisitor = new ConditionVisitor(updateSymbols);
            forStatementTree.accept((TreeVisitor)conditionVisitor);
            if (conditionVisitor.shouldRaiseIssue) {
                this.addIssue(tree, "This loop's stop condition tests \"" + Joiner.on((String)", ").join((Iterable)conditionVisitor.conditionNames) + "\" but the incrementer updates \"" + this.getSymbols(updateSymbols) + "\".");
            }
        }
    }

    private Collection<Symbol> getUpdatedSymbols(ForStatementTree forStatementTree) {
        UpdateVisitor updateVisitor = new UpdateVisitor();
        forStatementTree.accept((TreeVisitor)updateVisitor);
        return updateVisitor.symbols;
    }

    private String getSymbols(Collection<Symbol> updateSymbols) {
        ArrayList names = Lists.newArrayList();
        for (Symbol updateSymbol : updateSymbols) {
            names.add(updateSymbol.name());
        }
        return Joiner.on((String)", ").join((Iterable)names);
    }

    private static class ConditionVisitor
    extends BaseTreeVisitor {
        private final Collection<Symbol> updateSymbols;
        private final Collection<String> conditionNames;
        private boolean shouldRaiseIssue;

        ConditionVisitor(Collection<Symbol> updateSymbols) {
            this.updateSymbols = updateSymbols;
            this.conditionNames = Lists.newArrayList();
            this.shouldRaiseIssue = !updateSymbols.isEmpty();
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan((Tree)tree.condition());
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            if (tree.methodSelect().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.checkIdentifier(((MemberSelectExpressionTree)tree.methodSelect()).identifier());
            } else {
                this.scan((Tree)tree.methodSelect());
            }
            this.scan((ListTree)tree.typeArguments());
            this.scan(tree.arguments());
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.checkIdentifier(tree);
        }

        private void checkIdentifier(IdentifierTree tree) {
            Symbol reference = tree.symbol();
            String name = tree.name();
            if (reference.isMethodSymbol()) {
                name = name + "()";
            }
            this.conditionNames.add(name);
            if (this.updateSymbols.contains(reference)) {
                this.shouldRaiseIssue = false;
            }
        }
    }

    private static class UpdateVisitor
    extends BaseTreeVisitor {
        Collection<Symbol> symbols = Lists.newArrayList();

        private UpdateVisitor() {
        }

        public void visitForStatement(ForStatementTree tree) {
            this.scan(tree.update());
        }

        public void visitUnaryExpression(UnaryExpressionTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.addSymbol((IdentifierTree)tree.expression());
            }
            super.visitUnaryExpression(tree);
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (tree.variable().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                this.addSymbol((IdentifierTree)tree.variable());
            }
            super.visitAssignmentExpression(tree);
        }

        private void addSymbol(IdentifierTree identifierTree) {
            Symbol symbol = identifierTree.symbol();
            if (!symbol.isUnknown()) {
                this.symbols.add(symbol);
            }
        }
    }
}

