/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1849", name="\"Iterator.hasNext()\" should not call \"Iterator.next()\"", tags={"bug"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class HasNextCallingNextCheck
extends SubscriptionBaseVisitor {
    private HasNextBodyVisitor hasNextBodyVisitor = new HasNextBodyVisitor();

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        MethodTree methodTree = (MethodTree)tree;
        if (this.hasSemantic() && methodTree.block() != null && this.isHasNextMethod(methodTree)) {
            methodTree.block().accept((TreeVisitor)this.hasNextBodyVisitor);
        }
    }

    private boolean isHasNextMethod(MethodTree methodTree) {
        return "hasNext".equals(methodTree.simpleName().name()) && methodTree.parameters().isEmpty() && this.isIteratorMethod((Symbol)methodTree.symbol());
    }

    private boolean isIteratorMethod(Symbol method) {
        Type type = method.owner().enclosingClass().type();
        return !type.is("java.util.Iterator") && type.isSubtypeOf("java.util.Iterator");
    }

    private class HasNextBodyVisitor
    extends BaseTreeVisitor {
        private HasNextBodyVisitor() {
        }

        public void visitMethodInvocation(MethodInvocationTree tree) {
            Symbol method = tree.symbol();
            if ("next".equals(method.name()) && tree.arguments().isEmpty() && HasNextCallingNextCheck.this.isIteratorMethod(method)) {
                HasNextCallingNextCheck.this.addIssue((Tree)tree, "Refactor the implementation of this \"Iterator.hasNext()\" method to not call \"Iterator.next()\".");
            }
            super.visitMethodInvocation(tree);
        }

        public void visitClass(ClassTree tree) {
        }
    }
}

