/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Lists;
import java.util.Deque;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.ArrayTypeTree;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.CaseGroupTree;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="IndentationCheck", name="Source code should be indented consistently", tags={"convention"}, priority=Priority.MINOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="1min")
public class IndentationCheck
extends SubscriptionBaseVisitor {
    private static final Tree.Kind[] BLOCK_TYPES = new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.INTERFACE, Tree.Kind.ENUM, Tree.Kind.ANNOTATION_TYPE, Tree.Kind.CLASS, Tree.Kind.BLOCK, Tree.Kind.STATIC_INITIALIZER, Tree.Kind.INITIALIZER, Tree.Kind.SWITCH_STATEMENT, Tree.Kind.CASE_GROUP};
    private static final int DEFAULT_INDENTATION_LEVEL = 2;
    @RuleProperty(key="indentationLevel", description="Number of white-spaces of an indent. If this property is not set, we just check that the code is indented.", defaultValue="2")
    public int indentationLevel = 2;
    private int expectedLevel;
    private boolean isBlockAlreadyReported;
    private int lastCheckedLine;
    private Deque<Boolean> isInAnonymousClass = Lists.newLinkedList();

    public List<Tree.Kind> nodesToVisit() {
        return Lists.newArrayList((Object[])BLOCK_TYPES);
    }

    @Override
    public void scanFile(JavaFileScannerContext context) {
        this.expectedLevel = 0;
        this.isBlockAlreadyReported = false;
        this.lastCheckedLine = 0;
        this.isInAnonymousClass.clear();
        super.scanFile(context);
    }

    public void visitNode(Tree tree) {
        List labels;
        ClassTree classTree;
        if (this.isClassTree(tree)) {
            classTree = (ClassTree)tree;
            this.isInAnonymousClass.push(classTree.simpleName() == null);
            if (!this.isInAnonymousClass.peek().booleanValue()) {
                this.checkIndentation(Lists.newArrayList((Object[])new ClassTree[]{classTree}));
            }
        }
        this.expectedLevel += this.indentationLevel;
        this.isBlockAlreadyReported = false;
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP}) && (labels = ((CaseGroupTree)tree).labels()).size() >= 2) {
            this.lastCheckedLine = ((JavaTree)labels.get(labels.size() - 2)).getAstNode().getLastToken().getLine();
        }
        if (this.isClassTree(tree) && (classTree = (ClassTree)tree).simpleName() != null) {
            this.checkIndentation(classTree.members());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CASE_GROUP})) {
            this.checkIndentation(((CaseGroupTree)tree).body());
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            this.checkIndentation(((BlockTree)tree).body());
        }
    }

    private void checkIndentation(List<? extends Tree> trees) {
        for (Tree tree : trees) {
            int column = this.getColumn(tree);
            if (column != this.expectedLevel && !this.isExcluded(tree)) {
                this.addIssue(tree, "Make this line start at column " + (this.expectedLevel + 1) + ".");
                this.isBlockAlreadyReported = true;
            }
            this.lastCheckedLine = ((JavaTree)tree).getLastToken().getLine();
        }
    }

    private int getColumn(Tree tree) {
        ClassTree classTree;
        if (tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)tree;
            int typeColumn = this.getTypeColumn((Tree)variableTree.type());
            if (variableTree.modifiers().isEmpty()) {
                return typeColumn;
            }
            return Math.min(typeColumn, ((JavaTree)variableTree.modifiers()).getToken().getColumn());
        }
        if (this.isClassTree(tree) && !(classTree = (ClassTree)tree).modifiers().isEmpty()) {
            return ((JavaTree)classTree.modifiers()).getToken().getColumn();
        }
        return ((JavaTree)tree).getToken().getColumn();
    }

    private int getTypeColumn(Tree typeTree) {
        if (typeTree.is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE})) {
            return this.getTypeColumn((Tree)((ArrayTypeTree)typeTree).type());
        }
        return ((JavaTree)typeTree).getToken().getColumn();
    }

    public void leaveNode(Tree tree) {
        this.expectedLevel -= this.indentationLevel;
        this.isBlockAlreadyReported = false;
        this.lastCheckedLine = ((JavaTree)tree).getLastToken().getLine();
        if (this.isClassTree(tree)) {
            this.isInAnonymousClass.pop();
        }
    }

    private boolean isExcluded(Tree node) {
        return node.is(new Tree.Kind[]{Tree.Kind.ENUM_CONSTANT}) || this.isBlockAlreadyReported || !this.isLineFirstStatement((JavaTree)node) || this.isInAnonymousClass.peek() != false;
    }

    private boolean isLineFirstStatement(JavaTree javaTree) {
        return this.lastCheckedLine != javaTree.getTokenLine();
    }

    private boolean isClassTree(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CLASS, Tree.Kind.ENUM, Tree.Kind.INTERFACE, Tree.Kind.ANNOTATION_TYPE});
    }
}

