/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1214", name="Constants should not be defined in interfaces", tags={"bad-practice"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="ARCHITECTURE_CHANGEABILITY")
@SqaleConstantRemediation(value="10min")
public class InterfaceAsConstantContainerCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.INTERFACE);
    }

    public void visitNode(Tree tree) {
        if (this.hasConstant((ClassTree)tree)) {
            this.addIssue(tree, "Move constants to a class or enum.");
        }
    }

    private boolean hasConstant(ClassTree tree) {
        for (Tree member : tree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) continue;
            return true;
        }
        return false;
    }
}

