/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.annotations.Beta;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.LambdaExpressionTree;
import org.sonar.plugins.java.api.tree.StatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1602", name="Lamdbas containing only one statement should not nest this statement in a block", tags={"java8"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="5min")
@Beta
public class LambdaSingleExpressionCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree) {
        if (this.isBlockWithOneStatement(lambdaExpressionTree.body())) {
            String message = "Remove useless curly braces around statement";
            if (this.singleStatementIsReturn(lambdaExpressionTree)) {
                message = message + " and then remove useless return keyword";
            }
            this.context.addIssue(lambdaExpressionTree.body(), (JavaCheck)this, message);
        }
        super.visitLambdaExpression(lambdaExpressionTree);
    }

    private boolean isBlockWithOneStatement(Tree tree) {
        boolean result = false;
        if (tree.is(new Tree.Kind[]{Tree.Kind.BLOCK})) {
            List blockBody = ((BlockTree)tree).body();
            result = blockBody.size() == 1 && this.isRefactorizable((StatementTree)blockBody.get(0));
        }
        return result;
    }

    private boolean isRefactorizable(StatementTree statementTree) {
        return this.isBlockWithOneStatement((Tree)statementTree) || statementTree.is(new Tree.Kind[]{Tree.Kind.EXPRESSION_STATEMENT}) || this.isReturnStatement((Tree)statementTree);
    }

    private boolean singleStatementIsReturn(LambdaExpressionTree lambdaExpressionTree) {
        return this.isReturnStatement((Tree)((BlockTree)lambdaExpressionTree.body()).body().get(0));
    }

    private boolean isReturnStatement(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.RETURN_STATEMENT});
    }
}

