/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.NewClassTree;
import org.sonar.plugins.java.api.tree.ThrowStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1695", name="\"NullPointerException\" should not be explicitly thrown", tags={"pitfall"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="10min")
public class NPEThrowCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        if (context.getSemanticModel() != null) {
            this.scan((Tree)context.getTree());
        }
    }

    public void visitThrowStatement(ThrowStatementTree tree) {
        this.raiseIssueOnNpe((Tree)tree.expression(), tree.expression().symbolType());
        super.visitThrowStatement(tree);
    }

    public void visitMethod(MethodTree tree) {
        for (TypeTree throwClause : tree.throwsClauses()) {
            this.raiseIssueOnNpe((Tree)throwClause, throwClause.symbolType());
        }
        super.visitMethod(tree);
    }

    private void raiseIssueOnNpe(Tree tree, Type type) {
        if (type.is("java.lang.NullPointerException")) {
            this.context.addIssue(this.treeAtFault(tree), (JavaCheck)this, "Throw some other exception here, such as \"IllegalArgumentException\".");
        }
    }

    private Tree treeAtFault(Tree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS}) ? ((NewClassTree)tree).identifier() : tree;
    }
}

