/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.CompilationUnitTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2187", name="TestCases should contain tests", tags={"junit", "unused"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNIT_TESTABILITY")
@SqaleConstantRemediation(value="30min")
public class NoTestInTestClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.COMPILATION_UNIT);
    }

    public void visitNode(Tree tree) {
        CompilationUnitTree cut = (CompilationUnitTree)tree;
        for (Tree typeTree : cut.types()) {
            if (!typeTree.is(new Tree.Kind[]{Tree.Kind.CLASS})) continue;
            ClassTree classTree = (ClassTree)typeTree;
            this.checkJunit3TestClass(classTree);
            this.checkJunit4TestClass(classTree);
        }
    }

    private void checkJunit3TestClass(ClassTree tree) {
        if (tree.symbol().type().isSubtypeOf("junit.framework.TestCase")) {
            this.checkMethods(tree, false);
        }
    }

    private void checkJunit4TestClass(ClassTree tree) {
        IdentifierTree name = tree.simpleName();
        if (name != null && name.name().endsWith("Test")) {
            this.checkMethods(tree, true);
        }
    }

    private void checkMethods(ClassTree classTree, boolean forJunit4) {
        boolean hasNoTest = true;
        for (Tree member : classTree.members()) {
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !this.isTestMethod(forJunit4, (MethodTree)member)) continue;
            hasNoTest = false;
            break;
        }
        if (hasNoTest) {
            this.addIssue((Tree)classTree, "Add some tests to this class.");
        }
    }

    private boolean isTestMethod(boolean forJunit4, MethodTree member) {
        return forJunit4 && member.symbol().metadata().isAnnotatedWith("org.junit.Test") || member.simpleName().name().startsWith("test");
    }
}

