/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BinaryExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.ParenthesizedTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1697", name="Short-circuit logic should be used to prevent null pointer dereferences in conditionals", tags={"bug"}, priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="FAULT_TOLERANCE")
@SqaleConstantRemediation(value="2min")
public class NullDereferenceInConditionalCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitBinaryExpression(BinaryExpressionTree tree) {
        Tree nonNullOperand;
        IdentifierTree identifierTree;
        if ((this.isAndWithNullComparison(tree) || this.isOrWithNullExclusion(tree)) && (identifierTree = this.getIdentifier(nonNullOperand = this.getNonNullOperand((Tree)tree.leftOperand()))) != null) {
            IdentifierVisitor visitor = new IdentifierVisitor(identifierTree);
            tree.rightOperand().accept((TreeVisitor)visitor);
            if (visitor.raiseIssue) {
                this.context.addIssue((Tree)tree, (JavaCheck)this, "Either reverse the equality operator in the \"" + identifierTree.name() + "\" null test, or reverse the logical operator that follows it.");
            }
        }
        super.visitBinaryExpression(tree);
    }

    private IdentifierTree getIdentifier(Tree nonNullOperand) {
        if (nonNullOperand.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return (IdentifierTree)nonNullOperand;
        }
        if (nonNullOperand.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return this.getIdentifier((Tree)((ParenthesizedTree)nonNullOperand).expression());
        }
        return null;
    }

    private boolean isAndWithNullComparison(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_AND}) && this.isEqualNullComparison((Tree)tree.leftOperand());
    }

    private boolean isOrWithNullExclusion(BinaryExpressionTree tree) {
        return tree.is(new Tree.Kind[]{Tree.Kind.CONDITIONAL_OR}) && this.isNotEqualNullComparison((Tree)tree.leftOperand());
    }

    private boolean isEqualNullComparison(Tree tree) {
        return this.isNullComparison(tree, Tree.Kind.EQUAL_TO);
    }

    private boolean isNotEqualNullComparison(Tree tree) {
        return this.isNullComparison(tree, Tree.Kind.NOT_EQUAL_TO);
    }

    private boolean isNullComparison(Tree tree, Tree.Kind comparatorKind) {
        boolean result = false;
        if (tree.is(new Tree.Kind[]{comparatorKind})) {
            BinaryExpressionTree binary = (BinaryExpressionTree)tree;
            result = binary.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL}) || binary.rightOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL});
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return this.isNullComparison((Tree)((ParenthesizedTree)tree).expression(), comparatorKind);
        }
        return result;
    }

    private Tree getNonNullOperand(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.PARENTHESIZED_EXPRESSION})) {
            return this.getNonNullOperand((Tree)((ParenthesizedTree)tree).expression());
        }
        BinaryExpressionTree binaryExpressionTree = (BinaryExpressionTree)tree;
        if (binaryExpressionTree.leftOperand().is(new Tree.Kind[]{Tree.Kind.NULL_LITERAL})) {
            return binaryExpressionTree.rightOperand();
        }
        return binaryExpressionTree.leftOperand();
    }

    private static class IdentifierVisitor
    extends BaseTreeVisitor {
        private IdentifierTree identifierTree;
        boolean raiseIssue = false;

        IdentifierVisitor(IdentifierTree identifierTree) {
            this.identifierTree = identifierTree;
        }

        public void visitMemberSelectExpression(MemberSelectExpressionTree tree) {
            if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) || tree.expression().is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                this.scan((Tree)tree.expression());
            }
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            if (!this.isIdentifierWithSameName((Tree)tree.variable())) {
                this.scan((Tree)tree.variable());
            }
            this.scan((Tree)tree.expression());
        }

        public void visitBinaryExpression(BinaryExpressionTree tree) {
            boolean scanLeft = true;
            boolean scanRight = true;
            if (tree.is(new Tree.Kind[]{Tree.Kind.EQUAL_TO}) || tree.is(new Tree.Kind[]{Tree.Kind.NOT_EQUAL_TO})) {
                scanLeft = !this.isIdentifierWithSameName((Tree)tree.leftOperand());
                boolean bl = scanRight = !this.isIdentifierWithSameName((Tree)tree.rightOperand());
            }
            if (scanLeft) {
                this.scan((Tree)tree.leftOperand());
            }
            if (scanRight) {
                this.scan((Tree)tree.rightOperand());
            }
        }

        public void visitIdentifier(IdentifierTree tree) {
            this.raiseIssue |= this.equalsIdentName(tree);
        }

        private boolean equalsIdentName(IdentifierTree tree) {
            return this.identifierTree.name().equals(tree.name());
        }

        private boolean isIdentifierWithSameName(Tree tree) {
            return tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && this.equalsIdentName((IdentifierTree)tree);
        }
    }
}

