/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.NameCriteria;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.java.model.LiteralUtils;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.LiteralTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2695", name="\"PreparedStatement\" and \"ResultSet\" methods should be called with valid indices", tags={"bug", "sql"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="2min")
public class PreparedStatementAndResultSetCheck
extends AbstractMethodDetection {
    private static final String INT = "int";
    private static final String JAVA_SQL_RESULTSET = "java.sql.ResultSet";

    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition("java.sql.PreparedStatement").name(NameCriteria.startsWith("set")).addParameter(INT).addParameter(TypeCriteria.anyType()), (Object)MethodInvocationMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith("get")).addParameter(INT), (Object)MethodInvocationMatcher.create().typeDefinition(JAVA_SQL_RESULTSET).name(NameCriteria.startsWith("get")).addParameter(INT).addParameter(TypeCriteria.anyType()));
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        Integer methodFirstArgumentAsInteger = LiteralUtils.intLiteralValue((ExpressionTree)((ExpressionTree)mit.arguments().get(0)));
        if (methodFirstArgumentAsInteger == null) {
            return;
        }
        boolean isMethodFromJavaSqlResultSet = mit.symbol().owner().type().is(JAVA_SQL_RESULTSET);
        int methodFirstArgumentValue = methodFirstArgumentAsInteger;
        if (isMethodFromJavaSqlResultSet && methodFirstArgumentValue == 0) {
            this.addIssue((Tree)mit, "ResultSet indices start at 1.");
        } else if (!isMethodFromJavaSqlResultSet) {
            if (methodFirstArgumentValue == 0) {
                this.addIssue((Tree)mit, "PreparedStatement indices start at 1.");
            } else {
                Tree preparedStatementReference = this.getPreparedStatementReference(mit);
                Integer numberParameters = this.getNumberParametersFromPreparedStatement(preparedStatementReference);
                if (numberParameters != null && methodFirstArgumentValue > numberParameters) {
                    this.addIssue((Tree)mit, "This \"PreparedStatement\" " + (numberParameters == 0 ? "has no" : "only has " + numberParameters) + " parameters.");
                }
            }
        }
    }

    @CheckForNull
    private Tree getPreparedStatementReference(MethodInvocationTree mit) {
        ExpressionTree methodSelect = mit.methodSelect();
        if (methodSelect.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            ExpressionTree expression = ((MemberSelectExpressionTree)methodSelect).expression();
            if (expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol referenceSymbol = ((IdentifierTree)expression).symbol();
                return referenceSymbol.declaration();
            }
        }
        return null;
    }

    @CheckForNull
    private Integer getNumberParametersFromPreparedStatement(@Nullable Tree tree) {
        List arguments;
        ExpressionTree initializer;
        if (tree != null && tree.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) && (initializer = ((VariableTree)tree).initializer()) != null && initializer.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION}) && !(arguments = ((MethodInvocationTree)initializer).arguments()).isEmpty() && ((ExpressionTree)arguments.get(0)).is(new Tree.Kind[]{Tree.Kind.STRING_LITERAL})) {
            return StringUtils.countMatches((String)((LiteralTree)arguments.get(0)).value(), (String)"?");
        }
        return null;
    }
}

