/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.commons.lang.BooleanUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.declaration.MethodTreeImpl;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.ModifiersTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2156", name="\"final\" classes should not have \"protected\" members", tags={"confusing"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class ProtectedMemberInFinalClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (classTree.modifiers().modifiers().contains(Modifier.FINAL)) {
            for (Tree member : classTree.members()) {
                this.checkMember(member);
            }
        }
    }

    private void checkMember(Tree member) {
        MethodTreeImpl methodTree;
        if (member.is(new Tree.Kind[]{Tree.Kind.VARIABLE})) {
            VariableTree variableTree = (VariableTree)member;
            this.checkMemberModifier(variableTree.modifiers(), (Tree)variableTree);
        } else if (member.is(new Tree.Kind[]{Tree.Kind.METHOD}) && BooleanUtils.isFalse((Boolean)(methodTree = (MethodTreeImpl)member).isOverriding())) {
            this.checkMemberModifier(methodTree.modifiers(), (Tree)methodTree.simpleName());
        }
    }

    private void checkMemberModifier(ModifiersTree modifiers, Tree reportingTree) {
        if (modifiers.modifiers().contains(Modifier.PROTECTED)) {
            this.addIssue(reportingTree, "Remove this \"protected\" modifier.");
        }
    }
}

