/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;
import org.sonar.squidbridge.api.CheckMessage;
import org.sonar.squidbridge.api.SourceFile;

@Rule(key="RedundantThrowsDeclarationCheck", name="Throws declarations should not be redundant", tags={"error-handling"}, priority=Priority.MINOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="UNDERSTANDABILITY")
@SqaleConstantRemediation(value="5min")
public class RedundantThrowsDeclarationCheck
extends BytecodeVisitor {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        int line = this.getMethodLineNumber(asmMethod);
        if (line > 0) {
            HashSet reportedExceptions = Sets.newHashSet();
            List thrownClasses = asmMethod.getThrows();
            for (AsmClass thrownClass : thrownClasses) {
                String issueMessage;
                String thrownClassName = thrownClass.getDisplayName();
                if (reportedExceptions.contains(thrownClassName) || (issueMessage = this.getIssueMessage(thrownClasses, thrownClass)) == null) continue;
                reportedExceptions.add(thrownClassName);
                CheckMessage message = new CheckMessage((Object)this, issueMessage, new Object[0]);
                message.setLine(line);
                SourceFile file = this.getSourceFile(this.asmClass);
                file.log(message);
            }
        }
    }

    private String getIssueMessage(List<AsmClass> thrownClasses, AsmClass thrownClass) {
        String thrownClassName = thrownClass.getDisplayName();
        if (RedundantThrowsDeclarationCheck.isSubClassOfAny(thrownClass, thrownClasses)) {
            return "Remove the declaration of thrown exception '" + thrownClassName + "' which is a subclass of another one.";
        }
        if (RedundantThrowsDeclarationCheck.isSubClassOfRuntimeException(thrownClass)) {
            return "Remove the declaration of thrown exception '" + thrownClassName + "' which is a runtime exception.";
        }
        if (RedundantThrowsDeclarationCheck.isDeclaredMoreThanOnce(thrownClass, thrownClasses)) {
            return "Remove the redundant '" + thrownClassName + "' thrown exception declaration(s).";
        }
        return null;
    }

    private static boolean isDeclaredMoreThanOnce(AsmClass thrownClass, List<AsmClass> thrownClassCandidates) {
        int matches = 0;
        for (AsmClass thrownClassCandidate : thrownClassCandidates) {
            if (!thrownClass.equals((Object)thrownClassCandidate)) continue;
            ++matches;
        }
        return matches > 1;
    }

    private static boolean isSubClassOfAny(AsmClass thrownClass, List<AsmClass> thrownClassCandidates) {
        for (AsmClass current = thrownClass.getSuperClass(); current != null; current = current.getSuperClass()) {
            for (AsmClass thrownClassCandidate : thrownClassCandidates) {
                if (!current.equals((Object)thrownClassCandidate)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isSubClassOfRuntimeException(AsmClass thrownClass) {
        for (AsmClass current = thrownClass; current != null; current = current.getSuperClass()) {
            if (!"java/lang/RuntimeException".equals(current.getInternalName())) continue;
            return true;
        }
        return false;
    }
}

