/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.NewArrayTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1710", name="Annotation repetitions should not be wrapped", tags={"java8"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="READABILITY")
@SqaleConstantRemediation(value="2min")
public class RepeatAnnotationCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitAnnotation(AnnotationTree annotationTree) {
        NewArrayTree arrayTree;
        if (this.isArrayInitialized(annotationTree) && this.isAllSameAnnotation((arrayTree = (NewArrayTree)annotationTree.arguments().get(0)).initializers()) && this.isAnnotationRepeatable((ExpressionTree)arrayTree.initializers().get(0))) {
            this.context.addIssue((Tree)annotationTree, (JavaCheck)this, "Remove the '" + this.getAnnotationName((ExpressionTree)annotationTree) + "' wrapper from this annotation group");
        }
        super.visitAnnotation(annotationTree);
    }

    private boolean isAnnotationRepeatable(ExpressionTree expressionTree) {
        return expressionTree.symbolType().symbol().metadata().isAnnotatedWith("java.lang.annotation.Repeatable");
    }

    private boolean isAllSameAnnotation(List<ExpressionTree> initializers) {
        if (initializers.isEmpty()) {
            return false;
        }
        String annotationName = this.getAnnotationName(initializers.get(0));
        if (annotationName.isEmpty()) {
            return false;
        }
        for (int i = 1; i < initializers.size(); ++i) {
            if (annotationName.equals(this.getAnnotationName(initializers.get(i)))) continue;
            return false;
        }
        return true;
    }

    private String getAnnotationName(ExpressionTree initializer) {
        String result = "";
        if (initializer.is(new Tree.Kind[]{Tree.Kind.ANNOTATION})) {
            TypeTree annotationType = ((AnnotationTree)initializer).annotationType();
            if (annotationType.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                result = ((IdentifierTree)annotationType).name();
            } else if (annotationType.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                result = this.fullName((MemberSelectExpressionTree)annotationType);
            }
        }
        return result;
    }

    private String fullName(MemberSelectExpressionTree tree) {
        if (tree.expression().is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            return ((IdentifierTree)tree.expression()).name() + "." + tree.identifier().name();
        }
        return this.fullName((MemberSelectExpressionTree)tree.expression()) + "." + tree.identifier().name();
    }

    private boolean isArrayInitialized(AnnotationTree annotationTree) {
        return annotationTree.arguments().size() == 1 && ((ExpressionTree)annotationTree.arguments().get(0)).is(new Tree.Kind[]{Tree.Kind.NEW_ARRAY});
    }
}

