/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2151", name="\"runFinalizersOnExit\" should not be called", tags={"bug", "cert", "security"}, priority=Priority.BLOCKER)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class RunFinalizersCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.builder().add((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.Runtime").name("runFinalizersOnExit").addParameter("boolean")).add((Object)MethodInvocationMatcher.create().typeDefinition("java.lang.System").name("runFinalizersOnExit").addParameter("boolean")).build();
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Remove this call to \"" + mit.symbol().owner().name() + ".runFinalizersOnExit()\".");
    }
}

