/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.BlockTree;
import org.sonar.plugins.java.api.tree.ConditionalExpressionTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.IfStatementTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2301", name="Public methods should not contain selector arguments", tags={"design"}, priority=Priority.MAJOR)
@SqaleSubCharacteristic(value="MODULARITY")
@SqaleConstantRemediation(value="15min")
public class SelectorMethodArgumentCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        MethodTree methodTree = (MethodTree)tree;
        List<Symbol> booleanParameterSymbols = this.getBooleanParametersAsSymbol(methodTree.parameters());
        BlockTree blockTree = methodTree.block();
        if (this.isPublic(methodTree) && blockTree != null && !booleanParameterSymbols.isEmpty()) {
            for (Symbol variable : booleanParameterSymbols) {
                List usages = variable.usages();
                if (usages.size() != 1) continue;
                blockTree.accept((TreeVisitor)new ConditionalStatementVisitor(variable.name(), (IdentifierTree)Iterables.get((Iterable)usages, (int)0), tree));
            }
        }
    }

    private boolean isPublic(MethodTree methodTree) {
        return methodTree.modifiers().modifiers().contains(Modifier.PUBLIC);
    }

    private List<Symbol> getBooleanParametersAsSymbol(List<VariableTree> parameters) {
        LinkedList booleanParameters = Lists.newLinkedList();
        for (VariableTree variableTree : parameters) {
            if (!this.isBooleanVariable(variableTree)) continue;
            booleanParameters.add(variableTree.symbol());
        }
        return booleanParameters;
    }

    private boolean isBooleanVariable(VariableTree variableTree) {
        return variableTree.type().symbolType().isPrimitive(Type.Primitives.BOOLEAN);
    }

    private class ConditionalStatementVisitor
    extends BaseTreeVisitor {
        private final String variableName;
        private final Tree method;
        private IdentifierTree usage;

        public ConditionalStatementVisitor(String variableName, IdentifierTree usage, Tree method) {
            this.variableName = variableName;
            this.usage = usage;
            this.method = method;
        }

        public void visitIfStatement(IfStatementTree tree) {
            this.checkParameterUsage(tree.condition());
        }

        public void visitConditionalExpression(ConditionalExpressionTree tree) {
            this.checkParameterUsage(tree.condition());
        }

        private void checkParameterUsage(ExpressionTree condition) {
            if (this.usage.equals(condition)) {
                SelectorMethodArgumentCheck.this.addIssue(this.method, MessageFormat.format("Provide multiple methods instead of using \"{0}\" to determine which action to take.", this.variableName));
            }
        }
    }
}

