/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.resolve.JavaType;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1948", name="Fields in a \"Serializable\" class should either be transient or serializable", tags={"bug", "cwe", "serialization"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="DATA_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class SerializableFieldInSerializableClassCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.CLASS, (Object)Tree.Kind.ENUM);
    }

    public void visitNode(Tree tree) {
        ClassTree classTree = (ClassTree)tree;
        if (this.isSerializable((Tree)classTree) && !this.hasSpecialHandlingSerializationMethods(classTree)) {
            for (Tree member : classTree.members()) {
                if (!member.is(new Tree.Kind[]{Tree.Kind.VARIABLE}) || this.isStatic((VariableTree)member) || this.isTransientOrSerializable((VariableTree)member)) continue;
                this.addIssue(member, "Make \"" + ((VariableTree)member).simpleName().name() + "\" transient or serializable.");
            }
        }
    }

    private boolean isStatic(VariableTree member) {
        return member.modifiers().modifiers().contains(Modifier.STATIC);
    }

    private boolean hasSpecialHandlingSerializationMethods(ClassTree classTree) {
        boolean hasWriteObject = false;
        boolean hasReadObject = false;
        for (Tree member : classTree.members()) {
            MethodTree methodTree;
            if (!member.is(new Tree.Kind[]{Tree.Kind.METHOD}) || !(methodTree = (MethodTree)member).modifiers().modifiers().contains(Modifier.PRIVATE) || methodTree.parameters().size() != 1) continue;
            hasWriteObject |= "writeObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 1;
            hasReadObject |= "readObject".equals(methodTree.simpleName().name()) && methodTree.throwsClauses().size() == 2;
        }
        return hasReadObject && hasWriteObject;
    }

    private boolean isTransientOrSerializable(VariableTree member) {
        return member.modifiers().modifiers().contains(Modifier.TRANSIENT) || this.isSerializable((Tree)member.type());
    }

    private boolean isSerializable(Tree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.ENUM, Tree.Kind.PRIMITIVE_TYPE})) {
            return true;
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.CLASS})) {
            Symbol.TypeSymbol symbol = ((ClassTree)tree).symbol();
            return this.implementsSerializable(symbol.type());
        }
        return this.implementsSerializable(((TypeTree)tree).symbolType());
    }

    private boolean implementsSerializable(@Nullable Type type) {
        if (type == null || type.isUnknown()) {
            return false;
        }
        if (type.isPrimitive()) {
            return true;
        }
        if (type.isArray()) {
            return this.implementsSerializable(((Type.ArrayType)type).elementType());
        }
        if (type.isClass() || ((JavaType)type).isTagged(15)) {
            return type.erasure().isSubtypeOf("java.io.Serializable");
        }
        return false;
    }
}

