/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2226", name="Servlets should never have mutable instance fields", tags={"bug", "cert", "multi-threading", "struts"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="30min")
public class ServletInstanceFieldCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variable = (VariableTree)tree;
        if (this.hasSemantic() && this.isOwnedByAServlet(variable) && !this.isStaticOrFinal(variable)) {
            this.addIssue(tree, "Remove this misleading mutable servlet instance fields or make it \"static\" and/or \"final\"");
        }
    }

    private boolean isOwnedByAServlet(VariableTree variable) {
        Symbol owner = variable.symbol().owner();
        if (owner.isTypeSymbol()) {
            return owner.type().isSubtypeOf("javax.servlet.http.HttpServlet") || owner.type().isSubtypeOf("org.apache.struts.action.Action");
        }
        return false;
    }

    private boolean isStaticOrFinal(VariableTree variable) {
        List modifiers = variable.modifiers().modifiers();
        return modifiers.contains(Modifier.STATIC) || modifiers.contains(Modifier.FINAL);
    }
}

