/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.Modifier;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1873", name="\"static final\" arrays should be \"private\"", tags={"cwe", "security"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="API_ABUSE")
@SqaleConstantRemediation(value="15min")
public class StaticFinalArrayNotPrivateCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.VARIABLE);
    }

    public void visitNode(Tree tree) {
        VariableTree variableTree = (VariableTree)tree;
        if (variableTree.type().is(new Tree.Kind[]{Tree.Kind.ARRAY_TYPE}) && this.isStaticFinalNotPrivate(variableTree)) {
            this.addIssue(tree, "Make this array \"private\".");
        }
    }

    private boolean isStaticFinalNotPrivate(VariableTree variableTree) {
        return this.isStatic(variableTree) && this.isFinal(variableTree) && !this.isPrivate(variableTree);
    }

    private boolean isStatic(VariableTree variableTree) {
        return this.hasModifier(variableTree, Modifier.STATIC);
    }

    private boolean isFinal(VariableTree variableTree) {
        return this.hasModifier(variableTree, Modifier.FINAL);
    }

    private boolean isPrivate(VariableTree variableTree) {
        return this.hasModifier(variableTree, Modifier.PRIVATE);
    }

    private boolean hasModifier(VariableTree variableTree, Modifier modifier) {
        return variableTree.modifiers().modifiers().contains(modifier);
    }
}

