/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableMap;
import com.sonar.sslr.api.AstNode;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.AstNodeTokensMatcher;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.JavaCheck;
import org.sonar.plugins.java.api.JavaFileScanner;
import org.sonar.plugins.java.api.JavaFileScannerContext;
import org.sonar.plugins.java.api.semantic.Type;
import org.sonar.plugins.java.api.tree.AnnotationTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ClassTree;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.ListTree;
import org.sonar.plugins.java.api.tree.MethodTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TypeTree;
import org.sonar.plugins.java.api.tree.VariableTree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1149", name="Synchronized classes Vector, Hashtable, Stack and StringBuffer should not be used", tags={"multi-threading", "performance"}, priority=Priority.MAJOR)
@ActivatedByDefault
@SqaleSubCharacteristic(value="CPU_EFFICIENCY")
@SqaleConstantRemediation(value="20min")
public class SynchronizedClassUsageCheck
extends BaseTreeVisitor
implements JavaFileScanner {
    private static final Map<String, String> REPLACEMENTS = ImmutableMap.builder().put((Object)"java.util.Vector", (Object)"\"ArrayList\" or \"LinkedList\"").put((Object)"java.util.Hashtable", (Object)"\"HashMap\"").put((Object)"java.lang.StringBuffer", (Object)"\"StringBuilder\"").put((Object)"java.util.Stack", (Object)"\"Deque\"").build();
    private JavaFileScannerContext context;

    public void scanFile(JavaFileScannerContext context) {
        this.context = context;
        this.scan((Tree)context.getTree());
    }

    public void visitVariable(VariableTree tree) {
        ExpressionTree init;
        super.visitVariable(tree);
        boolean hasIssueOnDeclaredType = this.reportIssueIfDeprecatedType(tree.type());
        if (!hasIssueOnDeclaredType && (init = tree.initializer()) != null && init.is(new Tree.Kind[]{Tree.Kind.NEW_CLASS})) {
            this.reportIssueIfDeprecatedType(tree.initializer());
        }
    }

    public void visitMethod(MethodTree tree) {
        this.scan((ListTree)tree.modifiers());
        this.scan((ListTree)tree.typeParameters());
        this.scan((Tree)tree.returnType());
        this.scan((Tree)tree.defaultValue());
        this.scan((Tree)tree.block());
        if (!this.isOverriding(tree)) {
            for (VariableTree param : tree.parameters()) {
                this.reportIssueIfDeprecatedType(param.type());
            }
            this.reportIssueIfDeprecatedType(tree.returnType());
        }
    }

    public void visitClass(ClassTree tree) {
        super.visitClass(tree);
        for (TypeTree parent : tree.superInterfaces()) {
            this.reportIssueIfDeprecatedType(parent);
        }
    }

    private boolean reportIssueIfDeprecatedType(@Nullable ExpressionTree tree) {
        if (tree == null) {
            return false;
        }
        return this.reportIssueIfDeprecatedType(tree.symbolType(), (Tree)tree);
    }

    private boolean reportIssueIfDeprecatedType(@Nullable TypeTree tree) {
        if (tree == null) {
            return false;
        }
        return this.reportIssueIfDeprecatedType(tree.symbolType(), (Tree)tree);
    }

    private boolean reportIssueIfDeprecatedType(Type symbolType, Tree tree) {
        for (String forbiddenTypeName : REPLACEMENTS.keySet()) {
            if (!symbolType.is(forbiddenTypeName)) continue;
            this.reportIssue(tree, forbiddenTypeName);
            return true;
        }
        return false;
    }

    private void reportIssue(Tree tree, String type) {
        String simpleTypeName = type.substring(type.lastIndexOf(46) + 1);
        this.context.addIssue(tree, (JavaCheck)this, "Replace the synchronized class \"" + simpleTypeName + "\" by an unsynchronized one such as " + REPLACEMENTS.get(type) + ".");
    }

    private boolean isOverriding(MethodTree tree) {
        for (AnnotationTree annotation : tree.modifiers().annotations()) {
            AstNode node = ((JavaTree)annotation).getAstNode();
            if (!AstNodeTokensMatcher.matches(node, "@Override")) continue;
            return true;
        }
        return false;
    }
}

