/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import javax.annotation.CheckForNull;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.java.model.JavaTree;
import org.sonar.plugins.java.api.semantic.Symbol;
import org.sonar.plugins.java.api.tree.AssignmentExpressionTree;
import org.sonar.plugins.java.api.tree.BaseTreeVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.SynchronizedStatementTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.plugins.java.api.tree.TreeVisitor;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S2445", name="Blocks synchronized on fields should not contain assignments of new objects to those fields", tags={"multi-threading", "bug"}, priority=Priority.BLOCKER)
@SqaleSubCharacteristic(value="SYNCHRONIZATION_RELIABILITY")
@SqaleConstantRemediation(value="15min")
public class SynchronizedFieldAssignmentCheck
extends SubscriptionBaseVisitor {
    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.SYNCHRONIZED_STATEMENT);
    }

    public void visitNode(Tree tree) {
        if (!this.hasSemantic()) {
            return;
        }
        SynchronizedStatementTree sst = (SynchronizedStatementTree)tree;
        ExpressionTree synchronizedExpression = sst.expression();
        Symbol field = this.getField(synchronizedExpression);
        if (field != null) {
            sst.block().accept((TreeVisitor)new AssignmentVisitor(field, tree));
        }
    }

    @CheckForNull
    private Symbol getField(ExpressionTree tree) {
        MemberSelectExpressionTree mse;
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)tree).symbol();
            if (!reference.isUnknown() && reference.owner().isTypeSymbol()) {
                return reference;
            }
        } else if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT}) && this.isField((ExpressionTree)(mse = (MemberSelectExpressionTree)tree))) {
            return this.getField((ExpressionTree)mse.identifier());
        }
        return null;
    }

    private boolean isField(ExpressionTree tree) {
        if (tree.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            Symbol reference = ((IdentifierTree)tree).symbol();
            return !reference.isUnknown() && reference.owner().isTypeSymbol();
        }
        if (tree.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)tree;
            ExpressionTree mseExpression = mse.expression();
            if (this.isThis(mseExpression)) {
                return this.isField((ExpressionTree)mse.identifier());
            }
            return this.isField(mseExpression);
        }
        return false;
    }

    private boolean isThis(ExpressionTree expression) {
        return expression.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER}) && "this".equals(((IdentifierTree)expression).name());
    }

    private class AssignmentVisitor
    extends BaseTreeVisitor {
        private final Symbol field;
        private final Tree synchronizedStatement;

        public AssignmentVisitor(Symbol field, Tree tree) {
            this.field = field;
            this.synchronizedStatement = tree;
        }

        public void visitAssignmentExpression(AssignmentExpressionTree tree) {
            this.checkSymbolAssignment((Tree)tree.variable());
        }

        private void checkSymbolAssignment(Tree variable) {
            if (variable.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
                Symbol variableSymbol = ((IdentifierTree)variable).symbol();
                if (this.field.equals(variableSymbol)) {
                    SynchronizedFieldAssignmentCheck.this.addIssue(this.synchronizedStatement, this.getMessage(variable));
                }
            } else if (variable.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
                MemberSelectExpressionTree mse = (MemberSelectExpressionTree)variable;
                this.checkSymbolAssignment((Tree)mse.identifier());
            }
        }

        private String getMessage(Tree variable) {
            return MessageFormat.format("Don''t synchronize on \"{0}\" or remove its reassignment on line {1}.", this.field.name(), ((JavaTree)variable).getLine());
        }
    }
}

