/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.LinkedList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.SubscriptionBaseVisitor;
import org.sonar.plugins.java.api.tree.ExpressionTree;
import org.sonar.plugins.java.api.tree.IdentifierTree;
import org.sonar.plugins.java.api.tree.MemberSelectExpressionTree;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1147", name="Exit methods should not be called", tags={"cwe"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="SECURITY_FEATURES")
@SqaleConstantRemediation(value="30min")
public class SystemExitCalledCheck
extends SubscriptionBaseVisitor {
    private String idName;

    public List<Tree.Kind> nodesToVisit() {
        return ImmutableList.of((Object)Tree.Kind.METHOD_INVOCATION);
    }

    public void visitNode(Tree tree) {
        this.idName = "";
        MethodInvocationTree mit = (MethodInvocationTree)tree;
        if (this.isCallToExitMethod(mit)) {
            this.addIssue(tree, "Remove this call to \"" + this.idName + "\" or ensure it is really required.");
        }
    }

    private boolean isCallToExitMethod(MethodInvocationTree tree) {
        String selection = this.concatenate(tree.methodSelect());
        return "System.exit".equals(selection) || "Runtime.getRuntime().exit".equals(selection) || "Runtime.getRuntime().halt".equals(selection);
    }

    private String concatenate(ExpressionTree tree) {
        LinkedList<String> pieces = new LinkedList<String>();
        ExpressionTree expr = tree;
        while (expr.is(new Tree.Kind[]{Tree.Kind.MEMBER_SELECT})) {
            MemberSelectExpressionTree mse = (MemberSelectExpressionTree)expr;
            pieces.push(mse.identifier().name());
            pieces.push(".");
            expr = mse.expression();
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.METHOD_INVOCATION})) {
            pieces.push("()");
            pieces.push(this.concatenate(((MethodInvocationTree)expr).methodSelect()));
        }
        if (expr.is(new Tree.Kind[]{Tree.Kind.IDENTIFIER})) {
            IdentifierTree idt = (IdentifierTree)expr;
            pieces.push(idt.name());
        }
        StringBuilder sb = new StringBuilder();
        this.idName = (String)pieces.getLast();
        for (String piece : pieces) {
            sb.append(piece);
        }
        return sb.toString();
    }
}

