/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.checks;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.checks.methods.AbstractMethodDetection;
import org.sonar.java.checks.methods.MethodInvocationMatcher;
import org.sonar.java.checks.methods.TypeCriteria;
import org.sonar.plugins.java.api.tree.MethodInvocationTree;
import org.sonar.plugins.java.api.tree.Tree;
import org.sonar.squidbridge.annotations.ActivatedByDefault;
import org.sonar.squidbridge.annotations.SqaleConstantRemediation;
import org.sonar.squidbridge.annotations.SqaleSubCharacteristic;

@Rule(key="S1217", name="Thread.run() and Runnable.run() should not be called directly", tags={"cert", "cwe", "multi-threading"}, priority=Priority.CRITICAL)
@ActivatedByDefault
@SqaleSubCharacteristic(value="INSTRUCTION_RELIABILITY")
@SqaleConstantRemediation(value="20min")
public class ThreadRunCheck
extends AbstractMethodDetection {
    @Override
    protected List<MethodInvocationMatcher> getMethodInvocationMatchers() {
        return ImmutableList.of((Object)MethodInvocationMatcher.create().typeDefinition(TypeCriteria.subtypeOf("java.lang.Runnable")).name("run").withNoParameterConstraint());
    }

    @Override
    protected void onMethodFound(MethodInvocationTree mit) {
        this.addIssue((Tree)mit, "Call the method Thread.start() to execute the content of the run() method in a dedicated thread.");
    }
}

